/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.service;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.ValueNamePair;

public class CollectDetail {
    private String m_TenderType;
    private BigDecimal m_PayAmt;
    private BigDecimal m_InitPayAmt;
    private String m_ReferenceNo;
    private int m_C_Bank_ID;
    private Timestamp m_DateTrx;
    private String m_CreditCardExpMM;
    private String m_CreditCardExpYY;
    private String m_CreditCardNumber;
    private String m_CreditCardType;
    private String m_CreditCardVV;
    private String m_A_Name;
    private String m_A_City;
    private String m_A_State;
    private String m_A_Street;
    private String m_A_Zip;
    private String m_A_Country;
    private String m_A_EMail;
    private String m_A_Ident_DL;
    private String m_A_Ident_SSN;
    private String m_RoutingNo;
    private MInvoice m_CreditMemo;
    private int m_C_Invoice_ID;

    public CollectDetail(String string, BigDecimal bigDecimal, String string2, int n, Timestamp timestamp, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17) {
        this.m_TenderType = string;
        this.m_PayAmt = bigDecimal;
        this.m_ReferenceNo = string2;
        this.m_C_Bank_ID = n;
        this.m_DateTrx = timestamp;
        this.m_CreditCardExpMM = string3;
        this.m_CreditCardExpYY = string4;
        this.m_CreditCardNumber = string5;
        this.m_CreditCardType = string6;
        this.m_CreditCardVV = string7;
        this.m_A_Name = string8;
        this.m_A_City = string9;
        this.m_A_State = string10;
        this.m_A_Street = string11;
        this.m_A_Zip = string12;
        this.m_A_Country = string13;
        this.m_A_EMail = string14;
        this.m_A_Ident_DL = string15;
        this.m_A_Ident_SSN = string16;
        this.m_RoutingNo = string17;
    }

    public static CollectDetail createCreditCard(BigDecimal bigDecimal, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15) {
        return new CollectDetail("C", bigDecimal, null, 0, null, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15);
    }

    public static CollectDetail createCheck(BigDecimal bigDecimal, String string, int n, Timestamp timestamp) {
        return new CollectDetail("K", bigDecimal, string, n, timestamp);
    }

    public static CollectDetail createCash(BigDecimal bigDecimal) {
        return new CollectDetail("X", bigDecimal);
    }

    protected CollectDetail(String string, BigDecimal bigDecimal) {
        this.m_TenderType = string;
        this.m_PayAmt = bigDecimal;
        this.setInitPayAmt(bigDecimal);
        this.m_CreditCardType = "M";
    }

    private CollectDetail(String string, BigDecimal bigDecimal, String string2, int n, Timestamp timestamp) {
        this.m_TenderType = string;
        this.m_PayAmt = bigDecimal;
        this.m_ReferenceNo = string2;
        this.m_C_Bank_ID = n;
        this.m_DateTrx = timestamp;
    }

    protected ValueNamePair[] getCCMonths() {
        ArrayList<ValueNamePair> arrayList = new ArrayList<ValueNamePair>();
        Locale locale = Language.getLoginLanguage().getLocale();
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i <= 11; ++i) {
            calendar.set(1, i, 1);
            String string = calendar.getDisplayName(2, 1, locale);
            String string2 = String.format("%02d", i + 1);
            arrayList.add(new ValueNamePair(string2, string + "-" + string2));
        }
        ValueNamePair[] valueNamePairArray = new ValueNamePair[arrayList.size()];
        arrayList.toArray(valueNamePairArray);
        return valueNamePairArray;
    }

    protected ValueNamePair[] getCCYears() {
        ArrayList<ValueNamePair> arrayList = new ArrayList<ValueNamePair>();
        Locale locale = Language.getLoginLanguage().getLocale();
        Calendar calendar = Calendar.getInstance(locale);
        for (int i = 0; i < 10; ++i) {
            String string = String.valueOf(calendar.get(1));
            String string2 = string.substring(2);
            arrayList.add(new ValueNamePair(string2, string));
            calendar.add(1, 1);
        }
        ValueNamePair[] valueNamePairArray = new ValueNamePair[arrayList.size()];
        arrayList.toArray(valueNamePairArray);
        return valueNamePairArray;
    }

    public String getTenderType() {
        return this.m_TenderType;
    }

    public BigDecimal getPayAmt() {
        if (this.m_PayAmt == null) {
            return Env.ZERO;
        }
        return this.m_PayAmt;
    }

    public String getReferenceNo() {
        return this.m_ReferenceNo;
    }

    public int getC_Bank_ID() {
        return this.m_C_Bank_ID;
    }

    public Timestamp getDateTrx() {
        return this.m_DateTrx;
    }

    public String getCreditCardExpMM() {
        return this.m_CreditCardExpMM;
    }

    public String getCreditCardExpYY() {
        return this.m_CreditCardExpYY;
    }

    public String getCreditCardNumber() {
        return this.m_CreditCardNumber;
    }

    public String getCreditCardType() {
        return this.m_CreditCardType;
    }

    public String getCreditCardVV() {
        return this.m_CreditCardVV;
    }

    public String getA_Name() {
        return this.m_A_Name;
    }

    public String getA_City() {
        return this.m_A_City;
    }

    public String getA_State() {
        return this.m_A_State;
    }

    public String getA_Street() {
        return this.m_A_Street;
    }

    public String getA_Zip() {
        return this.m_A_Zip;
    }

    public String getA_Country() {
        return this.m_A_Country;
    }

    public String getA_EMail() {
        return this.m_A_EMail;
    }

    public String getA_Ident_DL() {
        return this.m_A_Ident_DL;
    }

    public String getA_Ident_SSN() {
        return this.m_A_Ident_SSN;
    }

    public String getRoutingNo() {
        return this.m_RoutingNo;
    }

    public void setTenderType(String string) {
        this.m_TenderType = string;
    }

    public void setPayAmt(BigDecimal bigDecimal) {
        this.m_PayAmt = bigDecimal;
    }

    public void setReferenceNo(String string) {
        this.m_ReferenceNo = string;
    }

    public void setC_Bank_ID(int n) {
        this.m_C_Bank_ID = n;
    }

    public void setDateTrx(Timestamp timestamp) {
        this.m_DateTrx = timestamp;
    }

    public void setCreditCardExpMM(String string) {
        this.m_CreditCardExpMM = string;
    }

    public void setCreditCardExpYY(String string) {
        this.m_CreditCardExpYY = string;
    }

    public void setCreditCardNumber(String string) {
        this.m_CreditCardNumber = string;
    }

    public void setCreditCardType(String string) {
        this.m_CreditCardType = string;
    }

    public void setCreditCardVV(String string) {
        this.m_CreditCardVV = string;
    }

    public void setA_Name(String string) {
        this.m_A_Name = string;
    }

    public void setA_City(String string) {
        this.m_A_City = string;
    }

    public void setA_State(String string) {
        this.m_A_State = string;
    }

    public void setA_Street(String string) {
        this.m_A_Street = string;
    }

    public void setA_Zip(String string) {
        this.m_A_Zip = string;
    }

    public void setA_Country(String string) {
        this.m_A_Country = string;
    }

    public void setA_EMail(String string) {
        this.m_A_EMail = string;
    }

    public void setA_Ident_DL(String string) {
        this.m_A_Ident_DL = string;
    }

    public void setA_Ident_SSN(String string) {
        this.m_A_Ident_SSN = string;
    }

    public void setRoutingNo(String string) {
        this.m_RoutingNo = string;
    }

    public int getC_Invoice_ID() {
        return this.m_C_Invoice_ID;
    }

    public void setC_Invoice_ID(int n) {
        this.m_C_Invoice_ID = n;
    }

    public BigDecimal getOpenAmtCreditMemo() {
        BigDecimal bigDecimal = Env.ZERO;
        if (this.m_C_Invoice_ID == 0) {
            return bigDecimal;
        }
        this.m_CreditMemo = MInvoice.get(Env.getCtx(), this.m_C_Invoice_ID);
        MDocType mDocType = MDocType.get(this.m_CreditMemo.getCtx(), this.m_CreditMemo.getC_DocType_ID());
        bigDecimal = this.m_CreditMemo.getOpenAmt();
        if ("API".equals(mDocType.getDocBaseType()) || "ARC".equals(mDocType.getDocBaseType())) {
            bigDecimal = bigDecimal.negate();
        }
        if (bigDecimal.compareTo(this.getPayAmt()) > 0) {
            bigDecimal = this.getPayAmt();
        }
        return bigDecimal;
    }

    public BigDecimal getInitPayAmt() {
        return this.m_InitPayAmt;
    }

    public void setInitPayAmt(BigDecimal bigDecimal) {
        this.m_InitPayAmt = bigDecimal;
    }

    protected MLookup getCreditMemoLockup(int n) {
        MLookup mLookup = null;
        int n2 = 12349;
        String string = "IsPaid='N' and Processed='Y' and C_BPartner_ID= " + n + " and exists ( select 1 from C_DocType C_DocType where C_DocType.DocBaseType ='ARC' \tand C_Invoice.C_DocTypeTarget_ID = C_DocType.C_DocType_ID)";
        try {
            mLookup = MLookupFactory.get(Env.getCtx(), 0, n2, 19, Env.getLanguage(Env.getCtx()), "C_Invoice_ID", 0, false, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mLookup;
    }

    public MInvoice getM_InvCreditMemo() {
        return this.m_CreditMemo;
    }

    public void setCreditMemo(MInvoice mInvoice) {
        this.m_CreditMemo = mInvoice;
    }

    public String toString() {
        return "CollectType [m_TenderType=" + this.m_TenderType + ", m_PayAmt=" + this.m_PayAmt + ", m_ReferenceNo=" + this.m_ReferenceNo + ", m_C_Bank_ID=" + this.m_C_Bank_ID + ", m_DateTrx=" + this.m_DateTrx + ", m_CreditCardExpMM=" + this.m_CreditCardExpMM + ", m_CreditCardExpYY=" + this.m_CreditCardExpYY + ", m_CreditCardNumber=" + this.m_CreditCardNumber + ", m_CreditCardType=" + this.m_CreditCardType + ", m_CreditCardVV=" + this.m_CreditCardVV + ", m_A_Name=" + this.m_A_Name + ", m_A_City=" + this.m_A_City + ", m_A_State=" + this.m_A_State + ", m_A_Street=" + this.m_A_Street + ", m_A_Zip=" + this.m_A_Zip + ", m_A_Country=" + this.m_A_Country + ", m_A_EMail=" + this.m_A_EMail + ", m_A_Ident_DL=" + this.m_A_Ident_DL + ", m_A_Ident_SSN=" + this.m_A_Ident_SSN + ", m_RoutingNo=" + this.m_RoutingNo + "]";
    }
}

