/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.service;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.adempiere.pos.service.CollectDetail;
import org.compiere.model.MBankStatement;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.MSysConfig;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class Collect {
    private String trxName;
    private MOrder order;
    private MPOS entityPOS;
    private int partnerId;
    private int bankAccountId;
    private Timestamp dateTrx;
    private List<CollectDetail> collectDetails;
    private boolean isCreditOrder = false;
    private int paymentTermId = 0;
    private StringBuffer errorMsg = new StringBuffer();

    public Collect(Properties properties, MOrder mOrder, int n) {
        this(properties, mOrder, MPOS.get(properties, n));
    }

    public Collect(Properties properties, MOrder mOrder, MPOS mPOS) {
        this.collectDetails = new ArrayList<CollectDetail>();
        this.entityPOS = mPOS;
        if (mOrder != null) {
            this.order = mOrder;
            this.partnerId = mOrder.getC_BPartner_ID();
            this.bankAccountId = mPOS.getC_BankAccount_ID();
            this.dateTrx = mOrder.getDateOrdered();
            this.trxName = mOrder.get_TrxName();
        }
    }

    public void load(Properties properties, MOrder mOrder, MPOS mPOS) {
        this.collectDetails = new ArrayList<CollectDetail>();
        this.entityPOS = mPOS;
        if (mOrder != null) {
            this.order = mOrder;
            this.partnerId = mOrder.getC_BPartner_ID();
            this.bankAccountId = mPOS.getC_BankAccount_ID();
            this.dateTrx = mOrder.getDateOrdered();
            this.trxName = mOrder.get_TrxName();
        }
    }

    public void addCollect(CollectDetail collectDetail) {
        this.collectDetails.add(collectDetail);
    }

    public void removeCollect(CollectDetail collectDetail) {
        this.collectDetails.remove(collectDetail);
    }

    public void removeAllCollectDetail() {
        int n = this.collectDetails.size();
        for (int i = n - 1; i >= 0; --i) {
            this.collectDetails.remove(i);
        }
    }

    public BigDecimal getCollectDetailAmt() {
        BigDecimal bigDecimal = Env.ZERO;
        for (CollectDetail collectDetail : this.collectDetails) {
            bigDecimal = bigDecimal.add(collectDetail.getPayAmt());
        }
        return bigDecimal;
    }

    protected BigDecimal getBalance(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this.getCollectDetailAmt();
        if (this.order != null) {
            return bigDecimal.subtract(bigDecimal2);
        }
        return Env.ZERO;
    }

    public void addCash(BigDecimal bigDecimal) {
        int n = this.findCash();
        CollectDetail collectDetail = null;
        if (n != -1) {
            collectDetail = this.collectDetails.get(n);
            collectDetail.setPayAmt(bigDecimal);
            this.collectDetails.set(n, collectDetail);
            return;
        }
        collectDetail = CollectDetail.createCash(bigDecimal);
        collectDetail.setDateTrx(this.getDateTrx());
        this.collectDetails.add(collectDetail);
    }

    public void addCheck(BigDecimal bigDecimal, String string, int n, Timestamp timestamp) {
        int n2 = this.findCheck(string);
        CollectDetail collectDetail = null;
        if (n2 != -1) {
            collectDetail = this.collectDetails.get(n2);
            collectDetail.setPayAmt(bigDecimal);
            this.collectDetails.set(n2, collectDetail);
            return;
        }
        collectDetail = CollectDetail.createCheck(bigDecimal, string, n, timestamp);
        this.collectDetails.add(collectDetail);
    }

    public int findCheck(String string) {
        for (int i = 0; i < this.collectDetails.size(); ++i) {
            CollectDetail collectDetail = this.collectDetails.get(i);
            if (!collectDetail.getTenderType().equals("K") || collectDetail.getReferenceNo() == null || !collectDetail.getReferenceNo().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean isExistCash() {
        for (CollectDetail collectDetail : this.collectDetails) {
            if (!collectDetail.getTenderType().equals("X")) continue;
            return true;
        }
        return false;
    }

    public boolean isExistOnlyOneCash() {
        int n = 0;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (!collectDetail.getTenderType().equals("X")) continue;
            ++n;
        }
        return n == 1 && this.collectDetails.size() == 1;
    }

    public int isExistCreditCard() {
        for (int i = 0; i < this.collectDetails.size(); ++i) {
            CollectDetail collectDetail = this.collectDetails.get(i);
            if (!collectDetail.getTenderType().equals("C")) continue;
            return i;
        }
        return -1;
    }

    public boolean isExistOnlyOneCreditCard() {
        int n = 0;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (!collectDetail.getTenderType().equals("C")) continue;
            ++n;
        }
        return n == 1 && this.collectDetails.size() == 1;
    }

    public int isExistCheck() {
        for (int i = 0; i < this.collectDetails.size(); ++i) {
            CollectDetail collectDetail = this.collectDetails.get(i);
            if (!collectDetail.getTenderType().equals("K")) continue;
            return i;
        }
        return -1;
    }

    public boolean isExistOnlyOneCheck() {
        int n = 0;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (!collectDetail.getTenderType().equals("K")) continue;
            ++n;
        }
        return n == 1 && this.collectDetails.size() == 1;
    }

    public int findCash() {
        for (int i = 0; i < this.collectDetails.size(); ++i) {
            CollectDetail collectDetail = this.collectDetails.get(i);
            if (!collectDetail.getTenderType().equals("X")) continue;
            return i;
        }
        return -1;
    }

    public boolean payCash(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        MPayment mPayment = this.createPayment("X");
        if (mPayment.isCashTrx() && !MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, mPayment.getAD_Client_ID())) {
            mPayment.setC_CashBook_ID(this.entityPOS.getC_CashBook_ID());
        } else {
            mPayment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        }
        mPayment.setAmount(this.order.getC_Currency_ID(), bigDecimal);
        mPayment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        mPayment.setDateTrx(this.getDateTrx());
        mPayment.setDateAcct(this.getDateTrx());
        mPayment.saveEx();
        mPayment.setOverUnderAmt(bigDecimal2);
        mPayment.saveEx();
        mPayment.setDocAction("CO");
        mPayment.setDocStatus("DR");
        if (mPayment.processIt("CO")) {
            mPayment.saveEx();
            MBankStatement.addPayment(mPayment);
            return true;
        }
        return false;
    }

    public boolean payCheck(BigDecimal bigDecimal, String string, String string2, String string3) {
        MPayment mPayment = this.createPayment("K");
        mPayment.setC_CashBook_ID(this.entityPOS.getC_CashBook_ID());
        mPayment.setAmount(this.order.getC_Currency_ID(), bigDecimal);
        mPayment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        mPayment.setAccountNo(string);
        mPayment.setRoutingNo(string2);
        mPayment.setCheckNo(string3);
        mPayment.setDescription(string3);
        mPayment.setDateTrx(this.getDateTrx());
        mPayment.setDateAcct(this.getDateTrx());
        mPayment.saveEx();
        mPayment.setDocAction("CO");
        mPayment.setDocStatus("DR");
        if (mPayment.processIt("CO")) {
            mPayment.saveEx();
            MBankStatement.addPayment(mPayment);
            return true;
        }
        return false;
    }

    public boolean payDirectDebit(BigDecimal bigDecimal, String string, String string2, String string3) {
        MPayment mPayment = this.createPayment("D");
        mPayment.setC_CashBook_ID(this.entityPOS.getC_CashBook_ID());
        mPayment.setAmount(this.order.getC_Currency_ID(), bigDecimal);
        mPayment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        mPayment.setRoutingNo(string);
        mPayment.setA_Country(string2);
        mPayment.setCreditCardVV(string3);
        mPayment.setDateTrx(this.getDateTrx());
        mPayment.setDateAcct(this.getDateTrx());
        mPayment.saveEx();
        mPayment.setDocAction("CO");
        mPayment.setDocStatus("DR");
        if (mPayment.processIt("CO")) {
            mPayment.saveEx();
            MBankStatement.addPayment(mPayment);
            return true;
        }
        return false;
    }

    public boolean payCreditCard(BigDecimal bigDecimal, String string, int n, int n2, String string2, String string3, String string4) {
        MPayment mPayment = this.createPayment("C");
        mPayment.setAmount(this.order.getC_Currency_ID(), bigDecimal);
        mPayment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        mPayment.setDateTrx(this.getDateTrx());
        mPayment.setDateAcct(this.getDateTrx());
        mPayment.setCreditCard("S", string4, string2, string3, n, n2);
        mPayment.saveEx();
        mPayment.setDocAction("CO");
        mPayment.setDocStatus("DR");
        if (mPayment.processIt("CO")) {
            mPayment.saveEx();
            MBankStatement.addPayment(mPayment);
            return true;
        }
        return false;
    }

    public boolean payCreditMemo(MInvoice mInvoice, BigDecimal bigDecimal) {
        int n = this.order.getC_Invoice_ID();
        if (n == 0) {
            return false;
        }
        MPayment mPayment = this.createPayment("T");
        if (mPayment.getC_Invoice_ID() > 0) {
            mPayment.setC_Invoice_ID(0);
        }
        if (mPayment.getC_Order_ID() > 0) {
            mPayment.setC_Order_ID(0);
        }
        if (mPayment.getC_Charge_ID() > 0) {
            mPayment.setC_Charge_ID(0);
        }
        mPayment.setAmount(this.order.getC_Currency_ID(), Env.ZERO);
        mPayment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        mPayment.setDateTrx(this.getDateTrx());
        mPayment.setDateAcct(this.getDateTrx());
        mPayment.saveEx();
        MPaymentAllocate mPaymentAllocate = new MPaymentAllocate(Env.getCtx(), 0, this.trxName);
        mPaymentAllocate.setC_Payment_ID(mPayment.getC_Payment_ID());
        mPaymentAllocate.setC_Invoice_ID(n);
        mPaymentAllocate.setInvoiceAmt(bigDecimal);
        mPaymentAllocate.setAmount(bigDecimal);
        mPaymentAllocate.saveEx();
        mPaymentAllocate = new MPaymentAllocate(Env.getCtx(), 0, this.trxName);
        mPaymentAllocate.setC_Payment_ID(mPayment.getC_Payment_ID());
        mPaymentAllocate.setC_Invoice_ID(mInvoice.getC_Invoice_ID());
        mPaymentAllocate.setAmount(bigDecimal.negate());
        mPaymentAllocate.setInvoiceAmt(bigDecimal.negate());
        mPaymentAllocate.saveEx();
        mPayment.setDocAction("CO");
        mPayment.setDocStatus("DR");
        if (mPayment.processIt("CO")) {
            mPayment.saveEx();
            MBankStatement.addPayment(mPayment);
            return true;
        }
        return false;
    }

    private MPayment createPayment(String string) {
        MPayment mPayment = new MPayment(Env.getCtx(), 0, this.trxName);
        mPayment.setAD_Org_ID(this.entityPOS.getAD_Org_ID());
        mPayment.setC_POS_ID(this.entityPOS.getC_POS_ID());
        mPayment.setTenderType(string);
        mPayment.setIsReceipt(true);
        mPayment.setC_Order_ID(this.order.getC_Order_ID());
        mPayment.setIsPrepayment(true);
        mPayment.setC_BPartner_ID(this.getC_BPartner_ID());
        mPayment.setDateTrx(this.getDateTrx());
        mPayment.setDateAcct(this.getDateTrx());
        int n = this.order.getC_Invoice_ID();
        if (n > 0) {
            mPayment.setC_Invoice_ID(n);
            MInvoice mInvoice = new MInvoice(Env.getCtx(), mPayment.getC_Invoice_ID(), this.trxName);
            mPayment.setDescription(Msg.getMsg(Env.getCtx(), "Invoice No ") + mInvoice.getDocumentNo());
        } else {
            mPayment.setDescription(Msg.getMsg(Env.getCtx(), "Order No ") + this.order.getDocumentNo());
        }
        this.order.setC_POS_ID(this.entityPOS.getC_POS_ID());
        this.order.saveEx(this.trxName);
        return mPayment;
    }

    private void addErrorMsg(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.errorMsg.length() > 0) {
            this.errorMsg.append(Env.NL);
        } else {
            this.errorMsg.append("@ValidationError@").append(Env.NL);
        }
        this.errorMsg.append(string);
    }

    public String getErrorMsg() {
        if (this.errorMsg != null && this.errorMsg.length() > 0) {
            return this.errorMsg.toString();
        }
        return null;
    }

    private void cleanErrorMsg() {
        this.errorMsg = new StringBuffer();
    }

    protected String validateTenderTypes(BigDecimal bigDecimal) {
        this.cleanErrorMsg();
        if (bigDecimal.doubleValue() <= 0.0) {
            this.addErrorMsg("@POS.validatePayment.NoOpenAmt@");
        }
        if (this.isAllowsPartialPayment()) {
            return null;
        }
        if (!this.isCreditOrder() && bigDecimal.subtract(this.getCollectDetailAmt()).doubleValue() > 0.0) {
            this.addErrorMsg("@POS.OrderPayNotCompleted@");
        }
        BigDecimal bigDecimal2 = Env.ZERO;
        BigDecimal bigDecimal3 = Env.ZERO;
        Object object = this.collectDetails.iterator();
        while (object.hasNext()) {
            Object object2;
            CollectDetail collectDetail = object.next();
            if (collectDetail.getPayAmt() == null || !(collectDetail.getPayAmt().doubleValue() > 0.0)) {
                this.addErrorMsg("@POS.validatePayment.ZeroAmount@");
                continue;
            }
            if (collectDetail.getTenderType().equals("X")) {
                bigDecimal2 = bigDecimal2.add(collectDetail.getPayAmt());
                continue;
            }
            if (collectDetail.getTenderType().equals("T")) {
                bigDecimal3 = bigDecimal3.add(collectDetail.getPayAmt());
                continue;
            }
            if (collectDetail.getTenderType().equals("D")) {
                bigDecimal3 = bigDecimal3.add(collectDetail.getPayAmt());
                continue;
            }
            if (collectDetail.getTenderType().equals("K")) {
                bigDecimal3 = bigDecimal3.add(collectDetail.getPayAmt());
                continue;
            }
            if (collectDetail.getTenderType().equals("C")) {
                bigDecimal3 = bigDecimal3.add(collectDetail.getPayAmt());
                object2 = collectDetail.getCreditCardExpMM() + collectDetail.getCreditCardExpYY();
                String string = MPaymentValidate.validateCreditCardExp((String)object2);
                if (string != null && !string.isEmpty()) {
                    this.addErrorMsg("@" + string + "@");
                }
                if ((string = MPaymentValidate.validateCreditCardNumber(collectDetail.getCreditCardNumber(), collectDetail.getCreditCardType())) == null || string.isEmpty()) continue;
                this.addErrorMsg("@" + string + "@");
                continue;
            }
            if (collectDetail.getTenderType().equals("M")) {
                if (collectDetail.getC_Invoice_ID() == 0) {
                    this.addErrorMsg("@POS.CreditMemoNotSelected@");
                }
                object2 = collectDetail.getOpenAmtCreditMemo();
                if (collectDetail.getPayAmt().compareTo((BigDecimal)object2) > 0) {
                    this.addErrorMsg("@POS.OpenAmountCreditMemo@ < @POS.PayAmt@ ");
                    collectDetail.setPayAmt((BigDecimal)object2);
                }
                bigDecimal3 = bigDecimal3.add(collectDetail.getPayAmt());
                continue;
            }
            this.addErrorMsg("@POS.validatePayment.UnsupportedPaymentType@");
        }
        if (bigDecimal3.subtract(bigDecimal).signum() == 1) {
            this.addErrorMsg("@POS.validatePayment.NonCashPaymentIncorrect@");
        }
        if (bigDecimal3.subtract(bigDecimal).signum() == 0 && bigDecimal2.signum() == 1) {
            this.addErrorMsg("@POS.validatePayment.CashPaymentNotNeeded@");
        }
        if (((BigDecimal)(object = bigDecimal2.add(bigDecimal3.subtract(bigDecimal)))).subtract(bigDecimal2).signum() == 1) {
            this.addErrorMsg("@POS.validatePayment.ChangeIncorrect@");
        }
        return this.getErrorMsg();
    }

    public void processTenderTypes(String string, BigDecimal bigDecimal) {
        boolean bl;
        this.cleanErrorMsg();
        this.trxName = string;
        BigDecimal bigDecimal2 = Env.ZERO;
        BigDecimal bigDecimal3 = Env.ZERO;
        BigDecimal bigDecimal4 = Env.ZERO;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (collectDetail.getTenderType().equals("X") || collectDetail.getTenderType().equals("T")) {
                bigDecimal3 = bigDecimal3.add(collectDetail.getPayAmt());
            } else if (collectDetail.getTenderType().equals("D")) {
                bigDecimal4 = bigDecimal4.add(collectDetail.getPayAmt());
                bl = this.payDirectDebit(collectDetail.getPayAmt(), collectDetail.getRoutingNo(), collectDetail.getA_Country(), collectDetail.getCreditCardVV());
                if (!bl) {
                    this.addErrorMsg("@POS.ErrorPaymentDirectDebit@");
                    return;
                }
            } else if (collectDetail.getTenderType().equals("K")) {
                bigDecimal4 = bigDecimal4.add(collectDetail.getPayAmt());
                bl = this.payCheck(collectDetail.getPayAmt(), null, collectDetail.getRoutingNo(), collectDetail.getReferenceNo());
                if (!bl) {
                    this.addErrorMsg("@POS.ErrorPaymentCheck@");
                    return;
                }
            } else if (collectDetail.getTenderType().equals("C")) {
                bigDecimal4 = bigDecimal4.add(collectDetail.getPayAmt());
                String string2 = collectDetail.getCreditCardExpMM() + collectDetail.getCreditCardExpYY();
                int n = MPaymentValidate.getCreditCardExpMM(string2);
                int n2 = MPaymentValidate.getCreditCardExpYY(string2);
                bl = this.payCreditCard(collectDetail.getPayAmt(), collectDetail.getA_Name(), n, n2, collectDetail.getCreditCardNumber(), collectDetail.getCreditCardVV(), collectDetail.getCreditCardType());
                if (!bl) {
                    this.addErrorMsg("@POS.ErrorPaymentCreditCard@");
                    return;
                }
            } else if (collectDetail.getTenderType().equals("M")) {
                if (this.isAllowsPartialPayment()) {
                    this.addErrorMsg("@POS.PrePayment.NoCreditMemoAllowed@");
                    return;
                }
                bigDecimal4 = bigDecimal4.add(collectDetail.getPayAmt());
                bl = this.payCreditMemo(collectDetail.getM_InvCreditMemo(), collectDetail.getPayAmt());
                if (!bl) {
                    this.addErrorMsg("@POS.ErrorPaymentCreditMEmo@");
                    return;
                }
            }
            bigDecimal2 = bigDecimal2.add(collectDetail.getPayAmt());
        }
        BigDecimal bigDecimal5 = bigDecimal.subtract(bigDecimal4.add(bigDecimal3));
        if (bigDecimal5.signum() == -1 && bigDecimal3.doubleValue() > 0.0) {
            if (bigDecimal5.abs().doubleValue() > bigDecimal3.doubleValue()) {
                this.addErrorMsg("@POS.validatePayment.PaymentBustBeExact@");
            } else {
                bl = this.payCash(bigDecimal3.add(bigDecimal5), bigDecimal5.negate());
                if (!bl) {
                    this.addErrorMsg("@POS.ErrorPaymentCash@");
                    return;
                }
            }
        } else if (bigDecimal3.signum() > 0 && !(bl = this.payCash(bigDecimal3, bigDecimal5.negate()))) {
            this.addErrorMsg("@POS.ErrorPaymentCash@");
            return;
        }
        this.order.saveEx(string);
    }

    public BigDecimal getPrePayAmt() {
        String string = "SELECT Sum(PayAmt) FROM C_Order o\tLEFT JOIN C_Payment p on p.C_order_ID = o.C_order_ID\tWHERE o.C_Order_ID = ?";
        BigDecimal bigDecimal = DB.getSQLValueBD(null, string, this.order.getC_Order_ID());
        if (bigDecimal == null) {
            bigDecimal = Env.ZERO;
        }
        return bigDecimal;
    }

    public ValueNamePair[] getCreditCards(BigDecimal bigDecimal, int n, int n2, int n3, String string) {
        try {
            MPaymentProcessor[] mPaymentProcessorArray = MPaymentProcessor.find(Env.getCtx(), null, null, n, n2, n3, bigDecimal, string);
            HashMap<String, ValueNamePair> hashMap = new HashMap<String, ValueNamePair>();
            for (int i = 0; i < mPaymentProcessorArray.length; ++i) {
                if (mPaymentProcessorArray[i].isAcceptAMEX()) {
                    hashMap.put("A", this.getCreditCardPair("A"));
                }
                if (mPaymentProcessorArray[i].isAcceptDiners()) {
                    hashMap.put("D", this.getCreditCardPair("D"));
                }
                if (mPaymentProcessorArray[i].isAcceptDiscover()) {
                    hashMap.put("N", this.getCreditCardPair("N"));
                }
                if (mPaymentProcessorArray[i].isAcceptMC()) {
                    hashMap.put("M", this.getCreditCardPair("M"));
                }
                if (mPaymentProcessorArray[i].isAcceptCorporate()) {
                    hashMap.put("P", this.getCreditCardPair("P"));
                }
                if (!mPaymentProcessorArray[i].isAcceptVisa()) continue;
                hashMap.put("V", this.getCreditCardPair("V"));
            }
            ValueNamePair[] valueNamePairArray = new ValueNamePair[hashMap.size()];
            hashMap.values().toArray(valueNamePairArray);
            return valueNamePairArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private ValueNamePair getCreditCardPair(String string) {
        return new ValueNamePair(string, this.getCreditCardName(string));
    }

    public String getCreditCardName(String string) {
        if (string == null) {
            return "--";
        }
        if ("M".equals(string)) {
            return "MasterCard";
        }
        if ("V".equals(string)) {
            return "Visa";
        }
        if ("A".equals(string)) {
            return "Amex";
        }
        if ("C".equals(string)) {
            return "ATM";
        }
        if ("D".equals(string)) {
            return "Diners";
        }
        if ("N".equals(string)) {
            return "Discover";
        }
        if ("P".equals(string)) {
            return "PurchaseCard";
        }
        return "?" + string + "?";
    }

    public int getC_BPartner_ID() {
        return this.partnerId;
    }

    public int getC_BankAccount_ID() {
        return this.bankAccountId;
    }

    public Timestamp getDateTrx() {
        return this.dateTrx;
    }

    public void setC_BPartner_ID(int n) {
        this.partnerId = n;
    }

    public void setC_BankAccount_ID(int n) {
        this.bankAccountId = n;
    }

    public void setDateTrx(Timestamp timestamp) {
        this.dateTrx = timestamp;
    }

    public void setC_PaymentTerm_ID(int n) {
        this.paymentTermId = n;
    }

    public int getC_PaymentTerm_ID() {
        return this.paymentTermId;
    }

    public boolean isCreditOrder() {
        return this.isCreditOrder;
    }

    public void setIsCreditOrder(boolean bl) {
        this.isCreditOrder = bl;
    }

    public boolean isAllowsPartialPayment() {
        return this.order != null && "WR".equals(this.order.getC_DocTypeTarget().getDocSubTypeSO()) && "CO".equals(this.order.getDocStatus());
    }

    public int getDetailQty() {
        return this.collectDetails.size();
    }

    public List<CollectDetail> getCollectDetails() {
        return this.collectDetails;
    }
}

