/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.service;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Vector;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.command.CommandManager;
import org.adempiere.pos.util.POSTicketHandler;
import org.compiere.model.I_AD_User;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.model.MInvoice;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MPOS;
import org.compiere.model.MPOSKey;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProductPricing;
import org.compiere.model.MSequence;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Order;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.ValueNamePair;
import org.eevolution.service.dsl.ProcessBuilder;

public class CPOS {
    private MPOS entityPOS;
    private MOrder currentOrder;
    private MSequence documentSequence;
    private MBPartner partner;
    private int priceListVersionId;
    private int priceListId;
    private Properties ctx;
    private Timestamp today;
    private ArrayList<Integer> orderList;
    private int recordPosition;
    private boolean isToPrint;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private BigDecimal quantity = BigDecimal.ZERO;
    private BigDecimal quantityAdded = BigDecimal.ZERO;
    private BigDecimal priceLimit = BigDecimal.ZERO;
    private BigDecimal price = BigDecimal.ZERO;
    private BigDecimal priceList = BigDecimal.ZERO;
    private BigDecimal discountPercentage = BigDecimal.ZERO;
    private boolean isAddQty = false;
    private int orderLineId = 0;
    private DecimalFormat decimalFormat;
    private SimpleDateFormat dateFormat;
    private int windowNo;

    public CPOS() {
        this.ctx = Env.getCtx();
        this.decimalFormat = DisplayType.getNumberFormat(12);
        this.dateFormat = DisplayType.getDateFormat(15);
        this.today = Env.getContextAsDate(this.ctx, "#Date");
    }

    public void setPOS(int n) {
        List<MPOS> list = this.getPOSByOrganization(Env.getAD_Org_ID(this.getCtx()));
        if (list.size() == 0) {
            throw new AdempierePOSException("@NoPOSForUser@");
        }
        if (list.size() == 1) {
            this.entityPOS = list.get(0);
        }
    }

    public void setM_POS(MPOS mPOS) {
        this.entityPOS = mPOS;
    }

    public DecimalFormat getNumberFormat() {
        return this.decimalFormat;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public void setWindowNo(int n) {
        this.windowNo = n;
    }

    public boolean isCompleted() {
        if (!this.hasOrder()) {
            return false;
        }
        return this.currentOrder.isProcessed() && "CO".equals(this.currentOrder.getDocStatus());
    }

    public int getAD_Sequence_ID() {
        if (this.entityPOS.getC_DocType_ID() > 0) {
            return this.entityPOS.getC_DocType().getDocNoSequence_ID();
        }
        throw new AdempierePOSException("@C_POS_ID@ @C_DocType_ID @NotFound@");
    }

    public int getAD_Org_ID() {
        return this.entityPOS.getAD_Org_ID();
    }

    public boolean isClosed() {
        if (!this.hasOrder()) {
            return false;
        }
        return "CL".equals(this.currentOrder.getDocStatus());
    }

    public boolean isVoided() {
        if (!this.hasOrder()) {
            return false;
        }
        return "VO".equals(this.currentOrder.getDocStatus());
    }

    public boolean isDrafted() {
        if (!this.hasOrder()) {
            return false;
        }
        return !this.isCompleted() && !this.isVoided() && "DR".equals(this.currentOrder.getDocStatus());
    }

    public boolean isInProgress() {
        if (!this.hasOrder()) {
            return false;
        }
        return !this.isCompleted() && !this.isVoided() && "IP".equals(this.currentOrder.getDocStatus());
    }

    public boolean isInvalid() {
        if (!this.hasOrder()) {
            return false;
        }
        return !this.isCompleted() && !this.isVoided() && "IN".equals(this.currentOrder.getDocStatus());
    }

    public boolean hasLines() {
        if (!this.hasOrder()) {
            return false;
        }
        return this.currentOrder.getLines().length > 0;
    }

    public boolean isPOSOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "WR".equals(this.getDocSubTypeSO());
    }

    public boolean isCreditOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "WI".equals(this.getDocSubTypeSO());
    }

    public boolean isStandardOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "SO".equals(this.getDocSubTypeSO());
    }

    public boolean isPrepayOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "PR".equals(this.getDocSubTypeSO());
    }

    public boolean isWarehouseOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "WP".equals(this.getDocSubTypeSO());
    }

    public boolean isReturnMaterial() {
        if (!this.hasOrder()) {
            return false;
        }
        return "RM".equals(this.getDocSubTypeSO());
    }

    public boolean isInvoiced() {
        if (!this.hasOrder()) {
            return false;
        }
        MInvoice[] mInvoiceArray = this.getOrder().getInvoices();
        boolean bl = false;
        if (mInvoiceArray != null && mInvoiceArray.length > 0) {
            bl = mInvoiceArray[0].getDocStatus().equalsIgnoreCase("CO");
        }
        return this.currentOrder.isInvoiced() || bl;
    }

    public boolean isDelivered() {
        if (!this.hasOrder()) {
            return false;
        }
        return this.currentOrder.isDelivered();
    }

    private String getDocSubTypeSO() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (mDocType != null && mDocType.getDocSubTypeSO() != null) {
            return mDocType.getDocSubTypeSO();
        }
        return "";
    }

    public int getC_DocType_ID() {
        if (!this.hasOrder()) {
            return 0;
        }
        if (this.isCompleted() || this.isVoided()) {
            return this.currentOrder.getC_DocType_ID();
        }
        return this.currentOrder.getC_DocTypeTarget_ID();
    }

    public boolean isToPrint() {
        return this.isToPrint;
    }

    public void setIsToPrint(boolean bl) {
        this.isToPrint = bl;
    }

    public MOrder getOrder() {
        return this.currentOrder;
    }

    public boolean hasOrder() {
        return this.currentOrder != null && this.currentOrder.getC_Order_ID() != 0;
    }

    public boolean hasBPartner() {
        return this.partner != null;
    }

    public boolean compareBPName(String string) {
        return this.partner.getName().equals(string);
    }

    public int getC_BPartner_ID() {
        if (this.hasBPartner()) {
            return this.partner.getC_BPartner_ID();
        }
        return 0;
    }

    public int getC_BankAccount_ID() {
        return this.entityPOS.getC_BankAccount_ID();
    }

    public String getBPName() {
        if (this.hasBPartner()) {
            return this.partner.getName();
        }
        return null;
    }

    public int getC_Currency_ID() {
        if (this.hasBPartner() && this.currentOrder != null) {
            return this.currentOrder.getC_Currency_ID();
        }
        return 0;
    }

    public int getAD_User_ID() {
        return Env.getAD_User_ID(Env.getCtx());
    }

    public int getAutoLogoutDelay() {
        if (this.entityPOS != null) {
            return this.entityPOS.getAutoLogoutDelay();
        }
        return 0;
    }

    public int getPINEntryTimeout() {
        if (this.entityPOS != null) {
            return this.entityPOS.getPINEntryTimeout();
        }
        return 0;
    }

    public String getSalesRepName() {
        if (this.currentOrder != null && this.currentOrder.getC_BPartner().getSalesRep_ID() != 0) {
            String string = this.currentOrder.getC_BPartner().getSalesRep().getName();
            return string;
        }
        MUser mUser = MUser.get(this.ctx);
        if (mUser == null) {
            return null;
        }
        return mUser.getName();
    }

    public int getSalesRep_ID() {
        if (this.currentOrder != null && this.currentOrder.getC_BPartner().getSalesRep_ID() != 0) {
            return this.currentOrder.getC_BPartner().getSalesRep_ID();
        }
        return this.entityPOS.getSalesRep_ID();
    }

    public MPOS getM_POS() {
        return this.entityPOS;
    }

    public String getPOSName() {
        return this.entityPOS.getName();
    }

    public int getC_POS_ID() {
        return this.entityPOS.getC_POS_ID();
    }

    public boolean isEnableProductLookup() {
        return this.entityPOS.isEnableProductLookup();
    }

    public boolean isRequiredPIN() {
        return this.entityPOS.isPOSRequiredPIN();
    }

    public void newOrder(int n) {
        this.log.info("PosPanel.newOrder");
        this.currentOrder = null;
        int n2 = this.entityPOS.getC_DocType_ID();
        this.createOrder(n, n2);
        this.reloadOrder();
    }

    public void setC_DocType_ID(int n) {
        if (!this.isDrafted()) {
            return;
        }
        this.currentOrder.setC_DocTypeTarget_ID(n);
        String string = DB.getDocumentNo(this.getC_DocType_ID(), null, false, (PO)this.currentOrder);
        if (string != null) {
            this.currentOrder.setDocumentNo(string);
        }
        this.currentOrder.saveEx();
    }

    private void createOrder(int n, int n2) {
        int n3 = this.getFreeC_Order_ID();
        if (n3 > 0) {
            this.currentOrder = new MOrder(Env.getCtx(), n3, null);
            this.currentOrder.setDateOrdered(this.getToday());
            this.currentOrder.setDateAcct(this.getToday());
            this.currentOrder.setDatePromised(this.getToday());
        } else {
            this.currentOrder = new MOrder(Env.getCtx(), 0, null);
        }
        this.currentOrder.setAD_Org_ID(this.entityPOS.getAD_Org_ID());
        this.currentOrder.setIsSOTrx(true);
        if (this.entityPOS.getM_PriceList_ID() > 0) {
            this.currentOrder.setM_PriceList_ID(this.entityPOS.getM_PriceList_ID());
        }
        if (this.entityPOS.getDeliveryRule() != null) {
            this.currentOrder.setDeliveryRule(this.getDeliveryRule());
        }
        if (this.entityPOS.getInvoiceRule() != null) {
            this.currentOrder.setInvoiceRule(this.getInvoiceRule());
        }
        this.currentOrder.setC_POS_ID(this.entityPOS.getC_POS_ID());
        this.currentOrder.setM_Warehouse_ID(this.entityPOS.getM_Warehouse_ID());
        if (n2 != 0) {
            this.currentOrder.setC_DocTypeTarget_ID(n2);
        } else {
            this.currentOrder.setC_DocTypeTarget_ID("WI");
        }
        this.configureBPartner(n);
        if (n3 < 0) {
            this.orderList.add(this.currentOrder.getC_Order_ID());
        }
        this.reloadIndex(this.currentOrder.getC_Order_ID());
    }

    private int getFreeC_Order_ID() {
        return DB.getSQLValue(null, "SELECT o.C_Order_ID FROM C_Order o WHERE o.DocStatus = 'DR' AND o.C_POS_ID = ? AND o.SalesRep_ID = ? AND NOT EXISTS(SELECT 1 \t\t\t\t\tFROM C_OrderLine ol \t\t\t\t\tWHERE ol.C_Order_ID = o.C_Order_ID) ORDER BY o.Updated", this.getC_POS_ID(), this.getSalesRep_ID());
    }

    public boolean isBPartnerStandard() {
        int n;
        int n2 = n = this.currentOrder != null ? this.currentOrder.getC_BPartner_ID() : 0;
        return this.entityPOS.getC_BPartnerCashTrx_ID() == n;
    }

    public void configureBPartner(int n) {
        MOrderLine[] mOrderLineArray;
        if (this.isCompleted() || this.isVoided()) {
            return;
        }
        this.log.fine("CPOS.setC_BPartner_ID=" + n);
        boolean bl = false;
        if (n == 0) {
            bl = true;
            n = this.entityPOS.getC_BPartnerCashTrx_ID();
        }
        this.partner = MBPartner.get(this.ctx, n);
        if (this.partner == null || this.partner.get_ID() == 0) {
            throw new AdempierePOSException("POS.NoBPartnerForOrder");
        }
        this.log.info("CPOS.SetC_BPartner_ID -" + this.partner);
        this.currentOrder.setBPartner(this.partner);
        MBPartnerLocation[] mBPartnerLocationArray = this.partner.getLocations(true);
        if (mBPartnerLocationArray.length > 0) {
            for (MBPartnerLocation mOrderLineArray2 : mBPartnerLocationArray) {
                if (mOrderLineArray2.isBillTo()) {
                    this.currentOrder.setBill_Location_ID(mOrderLineArray2.getC_BPartner_Location_ID());
                }
                if (!mOrderLineArray2.isShipTo()) continue;
                this.currentOrder.setShip_Location_ID(mOrderLineArray2.getC_BPartner_Location_ID());
            }
        }
        if (bl && this.currentOrder.getPaymentRule() == null) {
            this.currentOrder.setPaymentRule("B");
        }
        if (this.currentOrder.getC_BPartner().getSalesRep_ID() != 0) {
            this.currentOrder.setSalesRep_ID(this.currentOrder.getC_BPartner().getSalesRep_ID());
        } else {
            this.currentOrder.setSalesRep_ID(this.entityPOS.getSalesRep_ID());
        }
        this.currentOrder.saveEx();
        MPriceListVersion mPriceListVersion = this.loadPriceListVersion(this.currentOrder.getM_PriceList_ID());
        MProductPrice[] mProductPriceArray = mPriceListVersion.getProductPrice("AND EXISTS(SELECT 1 FROM C_OrderLine ol WHERE ol.C_Order_ID = " + this.currentOrder.getC_Order_ID() + " AND ol.M_Product_ID = M_ProductPrice.M_Product_ID)");
        for (MOrderLine mOrderLine : mOrderLineArray = this.currentOrder.getLines()) {
            if (this.existInPriceList(mOrderLine.getM_Product_ID(), mProductPriceArray)) {
                mOrderLine.setC_BPartner_ID(this.partner.getC_BPartner_ID());
                mOrderLine.setC_BPartner_Location_ID(this.currentOrder.getC_BPartner_Location_ID());
                mOrderLine.setPrice();
                mOrderLine.setTax();
                mOrderLine.saveEx();
                continue;
            }
            mOrderLine.deleteEx(true);
        }
    }

    private boolean existInPriceList(int n, MProductPrice[] mProductPriceArray) {
        for (MProductPrice mProductPrice : mProductPriceArray) {
            if (n != mProductPrice.getM_Product_ID()) continue;
            return true;
        }
        return false;
    }

    public List<MPOS> getPOSByOrganization(int n) {
        return MPOS.getByOrganization(this.ctx, n, null);
    }

    public Timestamp getToday() {
        return this.today;
    }

    public void setOrder(int n) {
        this.currentOrder = new MOrder(this.ctx, n, null);
        if (n != 0) {
            this.loadPriceListVersion(this.currentOrder.getM_PriceList_ID());
        }
        this.reloadOrder();
    }

    public BigDecimal[] updateLine(int n, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4, BigDecimal bigDecimal5) {
        if (!this.isDrafted()) {
            return null;
        }
        MOrderLine[] mOrderLineArray = this.currentOrder.getLines("AND C_OrderLine_ID = " + n, "Line");
        BigDecimal bigDecimal6 = Env.ZERO;
        BigDecimal bigDecimal7 = Env.ZERO;
        BigDecimal bigDecimal8 = Env.ZERO;
        for (MOrderLine mOrderLine : mOrderLineArray) {
            if (bigDecimal.compareTo(mOrderLine.getQtyOrdered()) == 0 && bigDecimal3.compareTo(mOrderLine.getPriceEntered()) == 0 && bigDecimal5.compareTo(mOrderLine.getDiscount()) == 0) {
                return null;
            }
            if (bigDecimal5.compareTo(mOrderLine.getDiscount()) != 0) {
                BigDecimal bigDecimal9 = mOrderLine.getPriceList().multiply(bigDecimal5.divide(Env.ONEHUNDRED));
                bigDecimal3 = mOrderLine.getPriceList().subtract(bigDecimal9);
            }
            mOrderLine.setPrice(bigDecimal3);
            mOrderLine.setQty(bigDecimal);
            mOrderLine.setTax();
            mOrderLine.saveEx();
            bigDecimal6 = mOrderLine.getLineNetAmt();
            bigDecimal7 = MTax.get(this.ctx, mOrderLine.getC_Tax_ID()).getRate();
            bigDecimal7 = bigDecimal7 == null ? Env.ZERO : bigDecimal7.divide(Env.ONEHUNDRED);
            bigDecimal8 = bigDecimal6.add(bigDecimal6.multiply(bigDecimal7));
        }
        return new BigDecimal[]{bigDecimal6, bigDecimal7, bigDecimal8};
    }

    public MOrderLine addOrUpdateLine(MProduct mProduct, BigDecimal bigDecimal, MProductPricing mProductPricing) {
        if (!this.isDrafted()) {
            return null;
        }
        MOrderLine[] mOrderLineArray = this.currentOrder.getLines(true, "Line");
        for (MOrderLine mOrderLine : mOrderLineArray) {
            if (mOrderLine.getM_Product_ID() != mProduct.getM_Product_ID()) continue;
            this.setOrderLineId(mOrderLine.getC_OrderLine_ID());
            BigDecimal bigDecimal2 = mOrderLine.getPriceEntered();
            BigDecimal bigDecimal3 = mOrderLine.getQtyEntered();
            BigDecimal bigDecimal4 = bigDecimal3.add(bigDecimal);
            mOrderLine.setQty(this.isAddQty() ? bigDecimal4 : bigDecimal);
            mOrderLine.setPrice(bigDecimal2);
            mOrderLine.saveEx();
            return mOrderLine;
        }
        MOrderLine mOrderLine = new MOrderLine(this.currentOrder);
        mOrderLine.setProduct(mProduct);
        mOrderLine.setQty(bigDecimal);
        mOrderLine.setPrice();
        if (mProductPricing.getPriceStd().signum() > 0) {
            mOrderLine.setPriceLimit(mProductPricing.getPriceLimit());
            mOrderLine.setPrice(mProductPricing.getPriceStd());
            mOrderLine.setPriceList(mProductPricing.getPriceList());
            this.setPriceLimit(mProductPricing.getPriceLimit());
            this.setPriceList(mProductPricing.getPriceList());
            BigDecimal bigDecimal5 = mOrderLine.getDiscount();
            this.setDiscountPercentage(bigDecimal5);
        }
        this.setOrderLineId(mOrderLine.getC_OrderLine_ID());
        mOrderLine.saveEx();
        return mOrderLine;
    }

    public String addOrUpdate(int n, BigDecimal bigDecimal) {
        String string = null;
        try {
            MProduct mProduct = MProduct.get(this.ctx, n);
            if (mProduct == null) {
                return "@No@ @InfoProduct@";
            }
            MProductPricing mProductPricing = new MProductPricing(n, this.getC_BPartner_ID(), bigDecimal, true, null);
            mProductPricing.setM_PriceList_ID(this.getM_PriceList_ID());
            mProductPricing.calculatePrice();
            if (!this.hasOrder()) {
                return "@POS.MustCreateOrder@";
            }
            this.addOrUpdateLine(mProduct, bigDecimal, mProductPricing);
        }
        catch (Exception exception) {
            string = exception.getMessage();
        }
        return string;
    }

    private boolean voidOrder() {
        if (!(this.currentOrder.getDocStatus().equals("DR") || this.currentOrder.getDocStatus().equals("IP") || this.currentOrder.getDocStatus().equals("CO"))) {
            return false;
        }
        this.currentOrder.setDocAction("VO");
        if (this.currentOrder.processIt("VO")) {
            this.currentOrder.setDocAction("--");
            this.currentOrder.setDocStatus("VO");
            this.currentOrder.saveEx();
            return true;
        }
        return false;
    }

    public String cancelOrder() {
        String string = null;
        try {
            int n = this.orderList.indexOf(this.currentOrder.getC_Order_ID());
            if (!this.hasOrder()) {
                throw new AdempierePOSException("@POS.MustCreateOrder@");
            }
            if (!this.isCompleted()) {
                this.currentOrder.deleteEx(true);
            } else if (this.isCompleted()) {
                this.voidOrder();
            } else {
                throw new AdempierePOSException("@POS.OrderIsNotProcessed@");
            }
            if (n >= 0) {
                this.orderList.remove(n);
            }
            this.currentOrder = null;
            if (this.hasRecord()) {
                if (this.isFirstRecord()) {
                    this.firstRecord();
                } else if (this.isLastRecord()) {
                    this.lastRecord();
                } else {
                    this.previousRecord();
                }
            }
        }
        catch (Exception exception) {
            string = exception.getMessage();
        }
        return string;
    }

    public void deleteLine(int n) {
        if (n != -1 && this.currentOrder != null) {
            for (MOrderLine mOrderLine : this.currentOrder.getLines(true, "M_Product_ID")) {
                if (mOrderLine.getC_OrderLine_ID() != n) continue;
                mOrderLine.deleteEx(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listOrder() {
        block6: {
            String string = new String("SELECT o.C_Order_ID FROM C_Order o WHERE o.IsSOTrx='Y' AND o.Processed = 'N' AND o.AD_Client_ID = ? AND o.C_POS_ID = ? AND o.SalesRep_ID = ? ORDER BY o.Updated");
            CPreparedStatement cPreparedStatement = null;
            ResultSet resultSet = null;
            this.orderList = new ArrayList();
            try {
                cPreparedStatement = DB.prepareStatement(string, null);
                cPreparedStatement.setInt(1, Env.getAD_Client_ID(Env.getCtx()));
                cPreparedStatement.setInt(2, this.getC_POS_ID());
                cPreparedStatement.setInt(3, this.getSalesRep_ID());
                resultSet = cPreparedStatement.executeQuery();
                while (resultSet.next()) {
                    this.orderList.add(resultSet.getInt(1));
                }
                DB.close(resultSet);
            }
            catch (Exception exception) {
                this.log.severe("SubOrder.listOrder: " + exception + " -> " + string);
                break block6;
            }
            finally {
                DB.close(resultSet);
                DB.close(cPreparedStatement);
            }
            DB.close(cPreparedStatement);
        }
        this.recordPosition = this.hasRecord() ? this.orderList.size() - 1 : -1;
    }

    public boolean hasRecord() {
        return !this.orderList.isEmpty();
    }

    public boolean isFirstRecord() {
        return this.recordPosition == 0;
    }

    public boolean isLastRecord() {
        return this.recordPosition == this.orderList.size() - 1;
    }

    public void previousRecord() {
        if (this.recordPosition > 0) {
            this.setOrder(this.orderList.get(--this.recordPosition));
        }
    }

    public void nextRecord() {
        if (this.recordPosition < this.orderList.size() - 1) {
            this.setOrder(this.orderList.get(++this.recordPosition));
        }
    }

    public void reloadIndex(int n) {
        int n2 = this.orderList.indexOf(n);
        if (n2 >= 0) {
            this.recordPosition = n2;
        }
    }

    public void lastRecord() {
        this.recordPosition = this.orderList.size();
        if (this.recordPosition != 0) {
            --this.recordPosition;
        }
    }

    public void firstRecord() {
        this.recordPosition = this.orderList.size();
        if (this.recordPosition != 0) {
            this.recordPosition = 0;
        }
    }

    public boolean processOrder(String string, boolean bl, boolean bl2) {
        boolean bl3 = this.isCompleted();
        if (bl3) {
            this.setIsToPrint(false);
        } else {
            if (string == null) {
                string = this.currentOrder.get_TrxName();
            } else {
                this.currentOrder.set_TrxName(string);
            }
            if (this.currentOrder.getDocStatus().equalsIgnoreCase("IN")) {
                this.currentOrder.setDocStatus("IP");
            }
            this.currentOrder.setDocAction("CO");
            if (this.currentOrder.processIt("CO")) {
                this.currentOrder.saveEx();
                bl3 = true;
                this.setIsToPrint(true);
            } else {
                this.log.info("Process Order FAILED " + this.currentOrder.getProcessMsg());
                this.currentOrder.saveEx();
                return bl3;
            }
        }
        if (bl2 && !this.isStandardOrder()) {
            if (!this.isDelivered()) {
                this.generateShipment(string);
            }
            if (!this.isInvoiced() && ("I".equals(this.currentOrder.getInvoiceRule()) || "D".equals(this.currentOrder.getInvoiceRule()) && this.isDelivered())) {
                this.generateInvoice(string);
            }
            bl3 = true;
        }
        return bl3;
    }

    private void generateShipment(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(this.getC_Order_ID());
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(199).withTitle(Msg.parseTranslation(this.getCtx(), "@InOutGenerateGen@")).withParameter("M_Warehouse_ID", this.getM_Warehouse_ID()).withParameter("Selection", true).withSelectedRecordsIds(MOrder.Table_ID, arrayList).withoutTransactionClose().execute(string);
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
    }

    public void completeReturn() {
        Trx.run(new TrxRunnable(){

            @Override
            public void run(String string) {
                String string2 = CPOS.this.completeReturn(string);
                if (string2 != null) {
                    throw new AdempiereException(string2);
                }
                if (CPOS.this.isToPrint()) {
                    CPOS.this.printTicket();
                }
            }
        });
    }

    private String completeReturn(String string) {
        Object object;
        if (this.isDrafted() || this.isInProgress() || this.isInvalid()) {
            if (!this.processOrder(string, false, false)) {
                return Msg.parseTranslation(this.getCtx(), " @ProcessRunError@. @order.no@: " + this.getDocumentNo() + ". @Process@: " + CommandManager.COMPLETE_DOCUMENT);
            }
            object = this.getDocSubTypeSO();
            if ((((String)object).equals("SO") || ((String)object).equals("WI") || ((String)object).equals("WP")) && this.isCompleted()) {
                return "@POS.IsNotReturn@";
            }
        }
        object = new MOrder(this.getCtx(), this.getC_Order_ID(), string);
        ((X_C_Order)object).setInvoiceRule("I");
        ((X_C_Order)object).setDeliveryRule("F");
        ((PO)object).saveEx();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(((PO)object).get_ID());
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(199).withParameter("M_Warehouse_ID", this.getM_Warehouse_ID()).withParameter("Selection", true).withSelectedRecordsIds(MOrder.Table_ID, arrayList).withoutTransactionClose().execute(string);
        if (processInfo.isError()) {
            return processInfo.getLogInfo();
        }
        for (MInOut mInOut : ((MOrder)object).getShipments()) {
            mInOut.processIt("CO");
            mInOut.saveEx();
            for (MInOutConfirm mInOutConfirm : mInOut.getConfirmations(true)) {
                for (MInOutLineConfirm mInOutLineConfirm : mInOutConfirm.getLines(true)) {
                    mInOutLineConfirm.setConfirmedQty(mInOutLineConfirm.getTargetQty());
                    mInOutLineConfirm.saveEx();
                }
                mInOutConfirm.processIt("CO");
                mInOutConfirm.saveEx();
            }
        }
        MOrder mOrder = (MOrder)((X_C_Order)object).getRef_Order();
        if (mOrder != null && ((X_C_Order)object).getC_Order_ID() > 0) {
            if (mOrder.getInvoices().length > 0) {
                processInfo = ProcessBuilder.create(this.getCtx()).process(134).withTitle(processInfo.getTitle()).withParameter("Selection", true).withSelectedRecordsIds(MOrder.Table_ID, arrayList).withParameter("DocAction", "CO").withoutTransactionClose().execute(string);
                if (processInfo.isError()) {
                    return processInfo.getLogInfo();
                }
            } else {
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                MPayment mPayment = new MPayment(((PO)object).getCtx(), 0, ((PO)object).get_TrxName());
                mPayment.setDateTrx(timestamp);
                mPayment.setC_Order_ID(((X_C_Order)object).getC_Order_ID());
                mPayment.setC_BankAccount_ID(this.getC_BankAccount_ID());
                mPayment.setDateAcct(timestamp);
                mPayment.addDescription(Msg.parseTranslation(((PO)object).getCtx(), " @C_Order_ID@ " + ((X_C_Order)object).getDocumentNo()));
                mPayment.setIsReceipt(false);
                mPayment.setC_DocType_ID(MDocType.getDocType("APP"));
                mPayment.setAmount(((X_C_Order)object).getC_Currency_ID(), ((X_C_Order)object).getGrandTotal());
                mPayment.setDocAction("CO");
                mPayment.setDocStatus("DR");
                mPayment.setIsPrepayment(true);
                mPayment.saveEx();
                mPayment.processIt("CO");
                mPayment.saveEx();
                ((X_C_Order)object).setC_POS_ID(this.getC_POS_ID());
                ((PO)object).saveEx();
                processInfo.addLog(0, null, null, mPayment.getDocumentInfo());
            }
        }
        this.setIsToPrint(true);
        return null;
    }

    private void generateInvoice(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(this.getC_Order_ID());
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(134).withTitle(Msg.parseTranslation(this.getCtx(), "@InvGenerateGen@")).withParameter("Selection", true).withParameter("DocAction", "CO").withSelectedRecordsIds(MOrder.Table_ID, arrayList).withoutTransactionClose().execute(string);
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
    }

    public String getProcessMsg() {
        return this.currentOrder.getProcessMsg();
    }

    public void setC_PaymentTerm_ID(int n) {
        if (n != 0 && this.hasOrder() && !this.isCompleted() && !this.isVoided()) {
            this.currentOrder.setC_PaymentTerm_ID(n);
        }
    }

    public int getC_PaymentTerm_ID() {
        if (this.hasOrder()) {
            return this.currentOrder.getC_PaymentTerm_ID();
        }
        return 0;
    }

    public BigDecimal getTaxAmt() {
        BigDecimal bigDecimal = Env.ZERO;
        for (MOrderTax mOrderTax : this.currentOrder.getTaxes(true)) {
            bigDecimal = bigDecimal.add(mOrderTax.getTaxAmt());
        }
        return bigDecimal;
    }

    public BigDecimal getTotalLines() {
        if (this.currentOrder != null) {
            return this.currentOrder.getGrandTotal().subtract(this.getTaxAmt());
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getGrandTotal() {
        if (this.currentOrder != null) {
            return this.currentOrder.getGrandTotal();
        }
        return BigDecimal.ZERO;
    }

    public String getDocumentNo() {
        return this.currentOrder.getDocumentNo();
    }

    public String getDeliveryRule() {
        return this.entityPOS.getDeliveryRule();
    }

    public String getInvoiceRule() {
        return this.entityPOS.getInvoiceRule();
    }

    public BigDecimal getOpenAmt() {
        if (this.currentOrder != null) {
            return this.currentOrder.getGrandTotal().subtract(this.getAmountReceived());
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getAmountReceived() {
        BigDecimal bigDecimal = Env.ZERO;
        for (MPayment mPayment : MPayment.getOfOrder(this.getOrder())) {
            bigDecimal = bigDecimal.add(mPayment.getPayAmt());
        }
        return bigDecimal;
    }

    public boolean isPaid() {
        return this.getOpenAmt().signum() == 0;
    }

    public BigDecimal getPaidAmt() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        BigDecimal bigDecimal3 = BigDecimal.ZERO;
        BigDecimal bigDecimal4 = BigDecimal.ZERO;
        if (this.currentOrder != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("C_Order_ID").append("=?").append(" AND ").append("DocStatus").append(" IN ('CO','CL') ");
            bigDecimal2 = new Query(this.getCtx(), "C_Payment", stringBuilder.toString(), null).setClient_ID().setParameters(this.currentOrder.getC_Order_ID()).sum("PayAmt");
            if (bigDecimal2 == null) {
                bigDecimal2 = Env.ZERO;
            }
            if (this.currentOrder.getC_Invoice_ID() > 1) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("EXISTS (SELECT 1 FROM ").append("C_AllocationHdr").append(" WHERE ").append("C_AllocationHdr").append(".").append("C_AllocationHdr_ID").append("=").append("C_AllocationLine").append(".").append("C_AllocationHdr_ID").append(" AND ").append("C_AllocationHdr").append(".").append("DocStatus").append(" IN ('CO','CL') AND ").append("C_AllocationLine").append(".").append("C_Invoice_ID").append("=?)");
                bigDecimal = new Query(this.getCtx(), "C_AllocationLine", stringBuilder.toString(), null).setClient_ID().setParameters(this.currentOrder.getC_Invoice_ID()).sum("Amount");
                if (bigDecimal == null) {
                    bigDecimal = Env.ZERO;
                }
                stringBuilder = new StringBuilder();
                stringBuilder.append("C_Invoice_ID").append("=?");
                bigDecimal3 = new Query(this.getCtx(), "C_CashLine", stringBuilder.toString(), null).setClient_ID().setParameters(this.currentOrder.getC_Invoice_ID()).sum("Amount");
                if (bigDecimal3 == null) {
                    bigDecimal3 = Env.ZERO;
                }
            }
        }
        bigDecimal4 = bigDecimal.add(bigDecimal2).add(bigDecimal3);
        return bigDecimal4;
    }

    public void reloadOrder() {
        if (this.currentOrder == null) {
            if (this.recordPosition != -1 && this.recordPosition < this.orderList.size()) {
                this.setOrder(this.orderList.get(this.recordPosition));
            }
            return;
        }
        this.currentOrder.load(this.currentOrder.get_TrxName());
        this.currentOrder.getLines(true, "Line");
        this.partner = MBPartner.get(this.getCtx(), this.currentOrder.getC_BPartner_ID());
    }

    public int getM_PriceList_Version_ID() {
        return this.priceListVersionId;
    }

    public int getM_PriceList_ID() {
        return this.priceListId;
    }

    public MPriceListVersion loadPriceListVersion(int n) {
        this.priceListVersionId = 0;
        this.priceListId = n;
        MPriceList mPriceList = MPriceList.get(this.ctx, n, null);
        MPriceListVersion mPriceListVersion = mPriceList.getPriceListVersion(this.getToday());
        if (mPriceListVersion != null && mPriceListVersion.getM_PriceList_Version_ID() != 0) {
            this.priceListVersionId = mPriceListVersion.getM_PriceList_Version_ID();
        }
        return mPriceListVersion;
    }

    public int getM_Warehouse_ID() {
        return this.entityPOS.getM_Warehouse_ID();
    }

    public void validLocator() {
        MLocator[] mLocatorArray;
        MWarehouse mWarehouse = MWarehouse.get(this.ctx, this.getM_Warehouse_ID());
        for (MLocator mLocator : mLocatorArray = mWarehouse.getLocators(true)) {
            if (!mLocator.isDefault()) continue;
            return;
        }
        throw new AdempierePOSException("@M_Locator_ID@ @default@ @not.found@ @M_Warehouse_ID@: " + mWarehouse.getName());
    }

    public String getWarehouseName() {
        if (this.getM_Warehouse_ID() > 0) {
            MWarehouse.get(this.ctx, this.getM_Warehouse_ID()).getName();
        }
        return "";
    }

    public String getDocumentTypeName() {
        MDocType mDocType;
        if (this.hasOrder() && (mDocType = MDocType.get(this.getCtx(), this.currentOrder.getC_DocTypeTarget_ID())) != null) {
            return mDocType.getName();
        }
        return "";
    }

    public Timestamp getDateOrdered() {
        if (this.hasOrder()) {
            return this.currentOrder.getDateOrdered();
        }
        return null;
    }

    public String getCurSymbol() {
        MCurrency mCurrency;
        int n = this.getC_Currency_ID();
        if (n > 0 && (mCurrency = MCurrency.get(this.getCtx(), n)) != null) {
            return mCurrency.getCurSymbol();
        }
        return "";
    }

    public ValueNamePair[] getCreditCards(BigDecimal bigDecimal) {
        try {
            MPaymentProcessor[] mPaymentProcessorArray = MPaymentProcessor.find(Env.getCtx(), null, null, this.currentOrder.getAD_Client_ID(), this.currentOrder.getAD_Org_ID(), this.currentOrder.getC_Currency_ID(), bigDecimal, this.currentOrder.get_TrxName());
            HashMap<String, ValueNamePair> hashMap = new HashMap<String, ValueNamePair>();
            for (int i = 0; i < mPaymentProcessorArray.length; ++i) {
                if (mPaymentProcessorArray[i].isAcceptAMEX()) {
                    hashMap.put("A", this.getCreditCardPair("A"));
                }
                if (mPaymentProcessorArray[i].isAcceptDiners()) {
                    hashMap.put("D", this.getCreditCardPair("D"));
                }
                if (mPaymentProcessorArray[i].isAcceptDiscover()) {
                    hashMap.put("N", this.getCreditCardPair("N"));
                }
                if (mPaymentProcessorArray[i].isAcceptMC()) {
                    hashMap.put("M", this.getCreditCardPair("M"));
                }
                if (mPaymentProcessorArray[i].isAcceptCorporate()) {
                    hashMap.put("P", this.getCreditCardPair("P"));
                }
                if (!mPaymentProcessorArray[i].isAcceptVisa()) continue;
                hashMap.put("V", this.getCreditCardPair("V"));
            }
            ValueNamePair[] valueNamePairArray = new ValueNamePair[hashMap.size()];
            hashMap.values().toArray(valueNamePairArray);
            this.log.fine("getCreditCards - #" + valueNamePairArray.length + " - Processors=" + mPaymentProcessorArray.length);
            return valueNamePairArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public ValueNamePair[] getCreditNotes() {
        try {
            String string = "C_BPartner_ID = ? AND IsPaid ='N' AND EXISTS(SELECT 1 \t\t\t\tFROM C_DocType dt \t\t\t\tWHERE dt.C_DocType_ID = C_Invoice.C_DocType_ID \t\t\t\tAND dt.DocBaseType ='ARC')";
            List list = new Query(Env.getCtx(), "C_Invoice", string, null).setParameters(this.currentOrder.getC_BPartner_ID()).list();
            HashMap<String, ValueNamePair> hashMap = new HashMap<String, ValueNamePair>();
            for (MInvoice mInvoice : list) {
                Integer n = mInvoice.getC_Invoice_ID();
                ValueNamePair valueNamePair = new ValueNamePair(n.toString(), mInvoice.getDocumentNo() + " " + mInvoice.getOpenAmt().toString());
                hashMap.put(mInvoice.getDocumentNo(), valueNamePair);
            }
            ValueNamePair[] valueNamePairArray = new ValueNamePair[hashMap.size()];
            hashMap.values().toArray(valueNamePairArray);
            return valueNamePairArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private ValueNamePair getCreditCardPair(String string) {
        return new ValueNamePair(string, this.getCreditCardName(string));
    }

    public String getCreditCardName(String string) {
        if (string == null) {
            return "--";
        }
        if ("M".equals(string)) {
            return "MasterCard";
        }
        if ("V".equals(string)) {
            return "Visa";
        }
        if ("A".equals(string)) {
            return "Amex";
        }
        if ("C".equals(string)) {
            return "ATM";
        }
        if ("D".equals(string)) {
            return "Diners";
        }
        if ("N".equals(string)) {
            return "Discover";
        }
        if ("P".equals(string)) {
            return "PurchaseCard";
        }
        return "?" + string + "?";
    }

    public Properties getCtx() {
        return this.ctx;
    }

    public int getOSKeyLayout_ID() {
        if (this.entityPOS != null) {
            return this.entityPOS.getOSK_KeyLayout_ID();
        }
        return 0;
    }

    public int getC_POSKeyLayout_ID() {
        if (this.entityPOS != null) {
            return this.entityPOS.getC_POSKeyLayout_ID();
        }
        return 0;
    }

    public boolean isModifyPrice() {
        return this.entityPOS.isModifyPrice();
    }

    public int getC_Order_ID() {
        int n = 0;
        if (this.hasOrder()) {
            n = this.currentOrder.getC_Order_ID();
        }
        return n;
    }

    public void saveNextSeq(String string) {
        int n = this.documentSequence.getCurrentNext() + this.documentSequence.getIncrementNo();
        this.documentSequence.setCurrentNext(n);
        this.documentSequence.saveEx(string);
    }

    public String getSequenceDoc(String string) {
        this.documentSequence = new MSequence(Env.getCtx(), this.getAD_Sequence_ID(), string);
        return this.documentSequence.getPrefix() + this.documentSequence.getCurrentNext();
    }

    public void setPOReference(String string) {
        String string2 = this.currentOrder.get_TrxName();
        Trx trx = Trx.get(string2, true);
        this.currentOrder.setPOReference(string);
        this.currentOrder.saveEx(trx.getTrxName());
        trx.close();
    }

    public BigDecimal getQty() {
        return this.quantity;
    }

    public void setQty(BigDecimal bigDecimal) {
        this.quantity = bigDecimal;
    }

    public BigDecimal getQtyAdded() {
        BigDecimal bigDecimal = this.quantityAdded;
        this.quantityAdded = Env.ZERO;
        this.setAddQty(false);
        return bigDecimal;
    }

    public void setQtyAdded(BigDecimal bigDecimal) {
        this.quantityAdded = bigDecimal;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getDiscountPercentage() {
        return this.discountPercentage;
    }

    public void setDiscountPercentage(BigDecimal bigDecimal) {
        this.discountPercentage = bigDecimal;
    }

    public void setPriceLimit(BigDecimal bigDecimal) {
        this.priceLimit = bigDecimal;
    }

    public BigDecimal getPriceLimit() {
        return this.priceLimit;
    }

    public BigDecimal getPriceList() {
        return this.priceList;
    }

    public void setPriceList(BigDecimal bigDecimal) {
        this.priceList = bigDecimal;
    }

    public void setPrice(BigDecimal bigDecimal) {
        this.price = bigDecimal;
    }

    public void setPrice(MProductPricing mProductPricing) {
        this.setPriceLimit(mProductPricing.getPriceLimit());
        this.setPrice(mProductPricing.getPriceStd());
        this.setPriceList(mProductPricing.getPriceList());
    }

    public String getElectronicScales() {
        if (this.entityPOS != null) {
            return this.entityPOS.getElectronicScales();
        }
        return null;
    }

    public String getMeasureRequestCode() {
        if (this.entityPOS != null) {
            return this.entityPOS.getMeasureRequestCode();
        }
        return null;
    }

    public boolean isPresentElectronicScales() {
        if (this.getElectronicScales() != null) {
            return this.getElectronicScales().length() > 0;
        }
        return false;
    }

    public boolean IsShowLineControl() {
        return true;
    }

    public boolean isVirtualKeyboard() {
        return this.getOSKeyLayout_ID() > 0;
    }

    public int getProductImageId(int n, int n2) {
        int n3 = 0;
        if (n == 0) {
            return n3;
        }
        int n4 = DB.getSQLValue(null, "SELECT pk.C_POSKey_ID FROM C_POSKey pk WHERE pk.C_POSKeyLayout_ID = ? AND pk.M_Product_ID = ? AND pk.IsActive = 'Y'", n2, n);
        if (n4 > 0) {
            MPOSKey mPOSKey = new MPOSKey(this.ctx, n4, null);
            n3 = mPOSKey.getAD_Image_ID();
        } else {
            n4 = DB.getSQLValue(null, "SELECT pk2.C_POSKey_ID FROM C_POSKey pk1 INNER JOIN C_POSKey pk2 ON pk1.subkeylayout_id=pk2.c_poskeylayout_id AND pk1.subkeylayout_id IS NOT NULL WHERE pk2.M_Product_ID = ? AND pk1.IsActive = 'Y' AND pk2.IsActive = 'Y'", n);
            if (n4 > 0) {
                MPOSKey mPOSKey = new MPOSKey(this.ctx, n4, null);
                n3 = mPOSKey.getAD_Image_ID();
            }
        }
        return n3;
    }

    public int getM_Product_ID(int n) {
        return DB.getSQLValue(null, "SELECT ol.M_Product_ID FROM C_OrderLine ol WHERE ol.C_OrderLine_ID = ?", n);
    }

    public boolean isValidUserPin(char[] cArray) {
        int n;
        if (cArray == null || cArray.length == 0) {
            return false;
        }
        MUser mUser = MUser.get(this.getCtx(), this.getAD_User_ID());
        Optional<I_AD_User> optional = Optional.of(mUser.getSupervisor());
        I_AD_User i_AD_User = optional.orElseThrow(() -> new AdempierePOSException("@Supervisor@ @NotFound@"));
        Optional<String> optional2 = Optional.ofNullable(i_AD_User.getName());
        if (i_AD_User.getUserPIN() == null || i_AD_User.getUserPIN().isEmpty()) {
            throw new AdempierePOSException("@Supervisor@ \"" + optional2.orElseGet(() -> "") + "\": @UserPIN@ @NotFound@");
        }
        char[] cArray2 = i_AD_User.getUserPIN().toCharArray();
        boolean bl = true;
        if (cArray.length != cArray2.length) {
            bl = false;
        } else {
            for (n = 0; n < cArray.length; ++n) {
                if (cArray[n] == cArray2[n]) continue;
                bl = false;
            }
        }
        for (n = 0; n < cArray2.length; ++n) {
            cArray2[n] = '\u0000';
        }
        return bl;
    }

    public String getProductValue(int n) {
        return DB.getSQLValueString(null, "SELECT Value FROM M_Product WHERE M_Product_ID = ? ", n);
    }

    public String getProductName(int n) {
        return DB.getSQLValueString(null, "SELECT name FROM M_Product WHERE M_Product_ID = ? ", n);
    }

    public static List<Vector<Object>> getQueryProduct(String string, int n, int n2, int n3) {
        ArrayList<Vector<Object>> arrayList = new ArrayList<Vector<Object>>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT DISTINCT ON ( ProductPricing.M_Product_ID , p.Value, p.Name ) ProductPricing.M_Product_ID , p.Value, p.Name,").append("   BomQtyAvailable(ProductPricing.M_Product_ID, ? , 0 ) AS QtyAvailable , PriceStd , PriceList").append(" FROM M_Product p INNER JOIN (").append("\tSELECT pl.M_PriceList_ID , plv.ValidFrom , 0 AS BreakValue , null AS C_BPartner_ID,").append("   p.M_Product_ID,").append("\tbomPriceStd(p.M_Product_ID,plv.M_PriceList_Version_ID) AS PriceStd,").append("\tbomPriceList(p.M_Product_ID,plv.M_PriceList_Version_ID) AS PriceList,").append("\tbomPriceLimit(p.M_Product_ID,plv.M_PriceList_Version_ID) AS PriceLimit").append("\tFROM M_Product p").append("\tINNER JOIN M_ProductPrice pp ON (p.M_Product_ID=pp.M_Product_ID)").append("\tINNER JOIN M_PriceList_Version plv ON (pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID)").append("\tINNER JOIN M_PriceList pl ON (plv.M_PriceList_ID=pl.M_PriceList_ID)").append("\tWHERE pl.M_PriceList_ID=? AND plv.IsActive='Y' AND pp.IsActive='Y' ").append("\tUNION\t").append("\tSELECT pl.M_PriceList_ID , plv.ValidFrom , pp.BreakValue , pp.C_BPartner_ID,").append("   p.M_Product_ID,").append("   pp.PriceStd, pp.PriceList, pp.PriceLimit").append("\tFROM M_Product p").append("\tINNER JOIN M_ProductPriceVendorBreak pp ON (p.M_Product_ID=pp.M_Product_ID)").append("\tINNER JOIN M_PriceList_Version plv ON (pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID)").append("\tINNER JOIN M_PriceList pl ON (plv.M_PriceList_ID=pl.M_PriceList_ID)").append("\tWHERE pl.M_PriceList_ID=? AND plv.IsActive='Y' AND pp.IsActive='Y'AND pp.BreakValue IN (0,1)").append("  ORDER BY ValidFrom DESC, BreakValue DESC , C_BPartner_ID ASC").append(") ProductPricing  ON (p.M_Product_ID=ProductPricing.M_Product_ID)").append(" WHERE ProductPricing.M_PriceList_ID=? AND ProductPricing.ValidFrom <= getDate() ");
        if (n3 > 0) {
            stringBuilder.append("AND (ProductPricing.C_BPartner_ID IS NULL OR ProductPricing.C_BPartner_ID =?) ");
        } else {
            stringBuilder.append("AND ProductPricing.C_BPartner_ID IS NULL ");
        }
        stringBuilder.append("AND p.AD_Client_ID=? AND p.IsSold=? AND p.Discontinued=? ").append("AND ").append("(").append("UPPER(p.Name)  LIKE UPPER('").append("%").append(string.replace(" ", "%")).append("%").append("')").append(" OR UPPER(p.Value) LIKE UPPER('").append("%").append(string.replace(" ", "%")).append("%").append("')").append(" OR UPPER(p.UPC)   LIKE UPPER('").append("%").append(string.replace(" ", "%")).append("%").append("')").append(" OR UPPER(p.SKU)   LIKE UPPER('").append("%").append(string.replace(" ", "%")).append("%").append("')").append(")");
        CPreparedStatement cPreparedStatement = null;
        try {
            cPreparedStatement = DB.prepareStatement(stringBuilder.toString(), null);
            int n4 = 1;
            cPreparedStatement.setInt(n4, n);
            cPreparedStatement.setInt(++n4, n2);
            cPreparedStatement.setInt(++n4, n2);
            cPreparedStatement.setInt(++n4, n2);
            ++n4;
            if (n3 > 0) {
                cPreparedStatement.setInt(n4, n3);
                ++n4;
            }
            cPreparedStatement.setInt(n4, Env.getAD_Client_ID(Env.getCtx()));
            cPreparedStatement.setString(++n4, "Y");
            cPreparedStatement.setString(++n4, "N");
            ResultSet resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                Vector<Object> vector = new Vector<Object>();
                Integer n5 = resultSet.getInt(1);
                String string2 = resultSet.getString(2).trim();
                String string3 = resultSet.getString(3).trim();
                String string4 = resultSet.getBigDecimal(4) != null ? resultSet.getBigDecimal(4).toString().trim() : "0";
                String string5 = resultSet.getBigDecimal(5) != null ? resultSet.getBigDecimal(5).setScale(2, 0).toString().trim() : "0";
                String string6 = resultSet.getBigDecimal(6) != null ? resultSet.getBigDecimal(6).setScale(2, 0).toString().trim() : "0 ";
                vector.add(n5);
                vector.add(string2);
                vector.add(string3);
                vector.add(string4);
                vector.add(string5);
                vector.add(string6);
                arrayList.add(vector);
            }
            DB.close(resultSet, cPreparedStatement);
            cPreparedStatement = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public void printTicket() {
        if (!this.hasOrder()) {
            return;
        }
        POSTicketHandler pOSTicketHandler = POSTicketHandler.getTicketHandler(this);
        if (pOSTicketHandler == null) {
            return;
        }
        pOSTicketHandler.printTicket();
    }

    public void setAddQty(boolean bl) {
        this.isAddQty = bl;
    }

    public boolean isAddQty() {
        return this.isAddQty;
    }

    public int getOrderLineId() {
        return this.orderLineId;
    }

    public void setOrderLineId(int n) {
        this.orderLineId = n;
    }

    public String getTotaLinesForView() {
        return this.getNumberFormat().format(this.getTotalLines());
    }

    public String getGrandTotalForView() {
        return this.getNumberFormat().format(this.getGrandTotal());
    }

    public String getTaxAmtForView() {
        return this.getNumberFormat().format(this.getGrandTotal().subtract(this.getTotalLines()));
    }

    public String getDateOrderedForView() {
        return this.getDateFormat().format(this.getDateOrdered());
    }

    public String getTicketHandlerClassName() {
        return this.entityPOS.getTicketClassName();
    }

    public String get_TrxName() {
        if (!this.hasOrder()) {
            return null;
        }
        return this.currentOrder.get_TrxName();
    }
}

