/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.search;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.sql.ResultSet;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.adempiere.pos.POSTextField;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.grid.VPOSBPartner;
import org.adempiere.pos.search.POSQuery;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MBPartnerInfo;
import org.compiere.model.MDocType;
import org.compiere.model.PO;
import org.compiere.swing.CLabel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class QueryDocType
extends POSQuery {
    private static final long serialVersionUID = -7109518709654253628L;
    private POSTextField f_Name;
    private POSTextField f_Description;
    private int m_C_DocType_ID;
    private String m_DocTypeName;
    private static CLogger log = CLogger.getCLogger(QueryDocType.class);
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "C_DocType_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Description"), "Description", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "SeqNo"), "SeqNo", String.class)};
    private static String s_sqlFrom = "C_DocType";
    private static String s_sqlWhere = "IsActive='Y'";

    public QueryDocType(VPOS vPOS) {
        super(vPOS);
    }

    @Override
    protected void init() {
        this.setTitle(Msg.translate(Env.getCtx(), "C_DocType_ID"));
        this.parameterPanel.setLayout((LayoutManager)new MigLayout("fill", "", "[50][50][]"));
        this.parameterPanel.setBorder(new TitledBorder(Msg.getMsg(this.ctx, "Query")));
        CLabel cLabel = new CLabel(Msg.translate(this.ctx, "Name"));
        this.parameterPanel.add((Component)cLabel, " growy");
        this.f_Name = new POSTextField("", this.posPanel.getKeyboard());
        cLabel.setLabelFor(this.f_Name);
        this.parameterPanel.add((Component)this.f_Name, "h 30, w 200");
        this.f_Name.addActionListener(this);
        CLabel cLabel2 = new CLabel(Msg.translate(this.ctx, "Description"));
        this.parameterPanel.add((Component)cLabel2, " growy");
        this.f_Description = new POSTextField("", this.posPanel.getKeyboard());
        cLabel.setLabelFor(this.f_Description);
        this.parameterPanel.add((Component)this.f_Description, "h 30, w 200");
        this.f_Description.addActionListener(this);
        this.posTable.prepareTable(s_layout, s_sqlFrom, s_sqlWhere, false, "C_DocType");
        this.posTable.growScrollbars();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryDocType.this.f_Name.requestFocus();
            }
        });
    }

    @Override
    protected void newAction() {
        super.newAction();
        VPOSBPartner vPOSBPartner = new VPOSBPartner(new Frame(), 0, this.posPanel);
        vPOSBPartner.setVisible(true);
        this.m_C_DocType_ID = vPOSBPartner.getC_BPartner_ID();
        this.close();
    }

    @Override
    public void editAction() {
        super.editAction();
        VPOSBPartner vPOSBPartner = new VPOSBPartner(new Frame(), 1, this.posPanel);
        this.select();
        vPOSBPartner.loadBPartner(this.m_C_DocType_ID);
        vPOSBPartner.setVisible(true);
        this.close();
    }

    private void setResultsFromArray(MDocType[] mDocTypeArray) {
        this.posTable.loadTable(mDocTypeArray);
        int n = this.posTable.getRowCount();
        if (n > 0) {
            this.posTable.setRowSelectionInterval(0, 0);
            if (n == 1) {
                this.select();
            }
        }
    }

    @Override
    public void setResults(PO[] pOArray) {
        if (pOArray == null || !(pOArray instanceof MDocType[])) {
            return;
        }
        this.setResultsFromArray((MDocType[])pOArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData() {
        block7: {
            StringBuffer stringBuffer = new StringBuffer();
            CPreparedStatement cPreparedStatement = null;
            ResultSet resultSet = null;
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                stringBuffer.append(" SELECT dt.C_DocType_ID, dt.Name, sq.Name, (COALESCE(sq.Prefix, '') || sq.CurrentNext || COALESCE(sq.Suffix, '')) SeqNo").append(" FROM C_DocType dt").append(" LEFT JOIN AD_Sequence sq ON (sq.AD_Sequence_ID = dt.DocNoSequence_ID)").append(" WHERE dt.AD_Client_ID = ? AND dt.AD_Org_ID IN (0, ?)").append(" AND dt.isActive='Y'").append(" AND dt.DocBaseType='SOO'").append(" AND dt.DocSubTypeSO IN(?, ?, ?, ?, ?)").append(" ORDER BY dt.Name");
                int n = 1;
                cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
                cPreparedStatement.setInt(n++, Env.getAD_Client_ID(this.ctx));
                cPreparedStatement.setInt(n++, this.posPanel.getAD_Org_ID());
                cPreparedStatement.setString(n++, "WR");
                cPreparedStatement.setString(n++, "WI");
                cPreparedStatement.setString(n++, "SO");
                cPreparedStatement.setString(n++, "PR");
                cPreparedStatement.setString(n++, "WP");
                resultSet = cPreparedStatement.executeQuery();
                this.posTable.loadTable(resultSet);
                int n2 = this.posTable.getRowCount();
                if (n2 > 0) {
                    this.posTable.setRowSelectionInterval(0, 0);
                    if (n2 == 1) {
                        this.select();
                    }
                }
                DB.close(resultSet);
            }
            catch (Exception exception) {
                log.severe("QueryTicket.setResults: " + exception + " -> " + stringBuffer);
                break block7;
            }
            finally {
                DB.close(resultSet);
                DB.close(cPreparedStatement);
                this.setCursor(Cursor.getDefaultCursor());
            }
            DB.close(cPreparedStatement);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    protected void select() {
        Integer n;
        boolean bl;
        this.cleanValues();
        int n2 = this.posTable.getSelectedRow();
        boolean bl2 = bl = n2 != -1;
        if (bl && (n = this.posTable.getSelectedRowKey()) != null) {
            this.m_C_DocType_ID = n;
            this.m_DocTypeName = (String)this.posTable.getValueAt(n2, 2);
        }
        log.fine("C_BPartner_ID=" + this.m_C_DocType_ID);
    }

    @Override
    protected void close() {
        this.dispose();
    }

    @Override
    public void reset() {
        this.f_Name.setText(null);
        this.setResults(new MBPartnerInfo[0]);
        this.cleanValues();
    }

    @Override
    public void refresh() {
        this.cleanValues();
        this.setResults(null);
    }

    private void cleanValues() {
        this.m_C_DocType_ID = -1;
        this.m_DocTypeName = null;
    }

    @Override
    protected void cancel() {
        this.cleanValues();
        this.dispose();
    }

    @Override
    public int getRecord_ID() {
        return this.m_C_DocType_ID;
    }

    @Override
    public String getValue() {
        return this.m_DocTypeName;
    }
}

