/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.util.Properties;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.adempiere.pos.POSTable;
import org.adempiere.pos.POSTextField;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.search.QueryOrderHistory;
import org.adempiere.pos.service.POSQueryInterface;
import org.adempiere.pos.service.POSQueryListener;
import org.compiere.apps.AEnv;
import org.compiere.apps.AppsAction;
import org.compiere.apps.StatusBar;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.PO;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public abstract class POSQuery
extends CDialog
implements MouseListener,
ActionListener,
KeyListener,
VetoableChangeListener,
POSQueryInterface {
    private static final long serialVersionUID = -6379099059318219432L;
    protected Properties ctx;
    protected VPOS posPanel = null;
    protected POSTable posTable;
    private CButton buttonNew;
    private CButton buttonEdit;
    private CButton buttonReset;
    private CButton buttonRefresh;
    private CButton buttonOk;
    private CButton buttonCancel;
    protected CPanel parameterPanel;
    private CScrollPane centerScroll;
    private CPanel confirmPanel;
    private CPanel mainPanel;
    private StatusBar statusBar;
    protected static CLogger logger = CLogger.getCLogger(QueryOrderHistory.class);
    private POSQueryListener listener;
    private final int BUTTON_WIDTH = 50;
    private final int BUTTON_HEIGHT = 50;
    private String statusBarInfo;

    public POSQuery() throws HeadlessException {
    }

    private void initMainPanel() {
        this.statusBarInfo = "";
        this.setLayout(new GridBagLayout());
        this.posTable = new POSTable();
        this.mainPanel = new CPanel(new GridBagLayout());
        this.mainPanel.setFocusCycleRoot(true);
        this.statusBar = new StatusBar();
        this.posTable.growScrollbars();
        this.parameterPanel = new CPanel(new GridBagLayout());
        this.centerScroll = new CScrollPane(this.posTable);
        this.confirmPanel = new CPanel(new GridBagLayout());
        this.centerScroll.setPreferredSize(new Dimension(800, 400));
        this.buttonNew = this.createButtonAction("New", KeyStroke.getKeyStroke(113, 0));
        this.buttonEdit = this.createButtonAction("Edit", KeyStroke.getKeyStroke(114, 0));
        this.buttonReset = this.createButtonAction("Reset", KeyStroke.getKeyStroke(118, 0));
        this.buttonRefresh = this.createButtonAction("Refresh", KeyStroke.getKeyStroke(116, 0));
        this.buttonCancel = this.createButtonAction("Cancel", KeyStroke.getKeyStroke(27, 0));
        this.buttonOk = this.createButtonAction("Ok", KeyStroke.getKeyStroke(10, 0));
        this.confirmPanel.add((Component)this.buttonNew, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.confirmPanel.add((Component)this.buttonEdit, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.confirmPanel.add((Component)this.buttonReset, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.confirmPanel.add((Component)this.buttonRefresh, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.confirmPanel.add((Component)this.buttonOk, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.confirmPanel.add((Component)this.buttonCancel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.parameterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.centerScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.confirmPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.statusBar, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonNew.setVisible(false);
        this.buttonEdit.setVisible(false);
        this.buttonEdit.setEnabled(false);
        this.posTable.addMouseListener(this);
        this.posTable.addKeyListener(this);
    }

    public void addOptionListener(POSQueryListener pOSQueryListener) {
        this.listener = pOSQueryListener;
    }

    public void setOkAction() {
        this.close();
        if (this.listener != null) {
            this.listener.okAction(this);
        }
    }

    public void setCancelAction() {
        if (this.listener != null) {
            this.listener.cancelAction(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        logger.info(actionEvent.getActionCommand());
        if (this.buttonNew.equals(actionEvent.getSource())) {
            this.newAction();
            this.dispose();
            return;
        }
        if (this.buttonEdit.equals(actionEvent.getSource())) {
            this.editAction();
            this.dispose();
            return;
        }
        if (this.buttonRefresh.equals(actionEvent.getSource())) {
            if (this.posTable == null) {
                return;
            }
            this.refresh();
            this.posTable.requestFocus();
            return;
        }
        if (this.buttonReset.equals(actionEvent.getSource())) {
            this.reset();
            return;
        }
        if (this.buttonCancel.equals(actionEvent.getSource())) {
            this.cancel();
            this.setCancelAction();
        } else if (this.buttonOk.equals(actionEvent.getSource())) {
            this.select();
            this.setOkAction();
        } else if (actionEvent.getSource() instanceof POSTextField || actionEvent.getSource() instanceof CCheckBox) {
            if (this.posTable == null) {
                return;
            }
            this.refresh();
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        logger.info(propertyChangeEvent.getPropertyName());
        if (propertyChangeEvent.getSource() instanceof VDate || propertyChangeEvent.getSource() instanceof VNumber || propertyChangeEvent.getSource() instanceof CComboBox) {
            if (this.posTable == null) {
                return;
            }
            this.refresh();
        }
    }

    protected void addNewAction() {
        this.buttonNew.setVisible(true);
        this.buttonEdit.setVisible(true);
    }

    protected abstract void close();

    public abstract void reset();

    public abstract void refresh();

    protected abstract void init();

    protected abstract void select();

    protected abstract void cancel();

    protected abstract void setResults(PO[] var1);

    protected void newAction() {
    }

    protected void editAction() {
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.parameterPanel = null;
        this.centerScroll = null;
        this.confirmPanel = null;
        this.posTable = null;
        super.dispose();
    }

    public POSQuery(VPOS vPOS) {
        super((Frame)Env.getWindow(vPOS.getWindowNo()), true);
        this.posPanel = vPOS;
        this.ctx = vPOS.getCtx();
        this.initMainPanel();
        this.init();
        this.pack();
        AEnv.positionCenterScreen(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 && this.posTable.getSelectedRow() != -1) {
            this.select();
            this.close();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.posTable.getSelectedRow() != -1) {
            this.buttonEdit.setEnabled(true);
        }
        if (mouseEvent.getClickCount() > 1 && this.posTable.getSelectedRow() != -1) {
            this.select();
            this.setOkAction();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected CButton createButtonAction(String string, KeyStroke keyStroke) {
        String string2 = "";
        if (string != null && keyStroke != null) {
            int n = keyStroke.getModifiers();
            if (n >= 0) {
                string2 = "(" + KeyEvent.getKeyModifiersText(n);
            }
            string2 = string2 + KeyEvent.getKeyText(keyStroke.getKeyCode());
            this.addStatusBarInfo(string + string2 + ")");
        }
        AppsAction appsAction = new AppsAction(string, keyStroke, false);
        appsAction.setDelegate(this);
        CButton cButton = (CButton)appsAction.getButton();
        cButton.setPreferredSize(new Dimension(50, 50));
        cButton.setMinimumSize(this.getPreferredSize());
        cButton.setMaximumSize(this.getPreferredSize());
        cButton.setFocusable(false);
        return cButton;
    }

    @Override
    public void showView() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                POSQuery.this.setVisible(true);
            }
        });
    }

    public void addStatusBarInfo(String string) {
        this.statusBarInfo = this.statusBarInfo + " " + string + " ";
        this.statusBar.setStatusLine(this.statusBarInfo);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.posTable.equals(keyEvent.getSource()) && 10 == keyEvent.getKeyCode()) {
            this.select();
            this.close();
            if (this.listener != null) {
                this.listener.okAction(this);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

