/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.process.ReverseTheSalesTransactionAbstract;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_InOutLine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Msg;
import org.eevolution.service.dsl.ProcessBuilder;

public class ReverseTheSalesTransaction
extends ReverseTheSalesTransactionAbstract {
    private Timestamp today;
    private List<MInOut> customerReturns = new ArrayList<MInOut>();

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice[] mInvoiceArray;
        this.today = new Timestamp(System.currentTimeMillis());
        MOrder mOrder = new MOrder(this.getCtx(), this.getOrderId(), this.get_TrxName());
        MInOut[] mInOutArray = mOrder.getShipments();
        if (mInOutArray.length > 0 && (mOrder.getC_BPartner_ID() != this.getInvoicePartnerId() || this.isCancelled())) {
            this.cancelShipments(mInOutArray);
        }
        if ((mInvoiceArray = mOrder.getInvoices()).length > 0 && (mOrder.getC_BPartner_ID() != this.getInvoicePartnerId() || this.isCancelled())) {
            this.cancelInvoices();
        }
        for (MPayment mPayment : ReverseTheSalesTransaction.cancelPayments(mOrder, this.today)) {
            this.addLog(mPayment.getDocumentInfo());
        }
        mOrder.processIt("CL");
        mOrder.saveEx();
        return "@Ok@";
    }

    private void cancelShipments(MInOut[] mInOutArray) {
        for (MInOut mInOut : mInOutArray) {
            MRMA mRMA = new MRMA(this.getCtx(), 0, this.get_TrxName());
            mRMA.setM_InOut_ID(mInOut.getM_InOut_ID());
            mRMA.setAD_Org_ID(mInOut.getAD_Org_ID());
            mRMA.setM_RMAType_ID(this.getRMATypeId());
            mRMA.setC_BPartner_ID(mInOut.getC_BPartner_ID());
            mRMA.setName(mInOut.getDocumentInfo());
            mRMA.setIsSOTrx(true);
            mRMA.setSalesRep_ID(mInOut.getSalesRep_ID());
            mRMA.setC_DocType_ID(MDocType.getDocTypeBaseOnSubType(mInOut.getAD_Org_ID(), "SOO", "RM"));
            mRMA.setDocStatus("DR");
            mRMA.setDocAction("CO");
            mRMA.saveEx();
            MInOut mInOut2 = new MInOut(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(mInOut, mInOut2);
            mInOut2.setDocumentNo(null);
            mInOut2.setM_RMA_ID(mRMA.getM_RMA_ID());
            mInOut2.setIsSOTrx(true);
            mInOut2.setC_BPartner_ID(mInOut.getC_BPartner_ID());
            mInOut2.setC_Order_ID(-1);
            for (MDocType mDocType : MDocType.getOfDocBaseType(this.getCtx(), "MMR")) {
                if (!mDocType.isSOTrx()) continue;
                mInOut2.setC_DocType_ID();
            }
            mInOut2.setMovementType("C+");
            mInOut2.setDocStatus("DR");
            mInOut2.setDocAction("CO");
            mInOut2.setProcessed(false);
            mInOut2.saveEx();
            for (PO pO : mInOut.getLines()) {
                MInOutLineConfirm[] mInOutLineConfirmArray = new MRMALine(this.getCtx(), 0, this.get_TrxName());
                mInOutLineConfirmArray.setM_RMA_ID(mRMA.getM_RMA_ID());
                mInOutLineConfirmArray.setAD_Org_ID(pO.getAD_Org_ID());
                mInOutLineConfirmArray.setM_InOutLine_ID(((X_M_InOutLine)pO).getM_InOutLine_ID());
                mInOutLineConfirmArray.setQty(((X_M_InOutLine)pO).getMovementQty());
                mInOutLineConfirmArray.saveEx();
                MInOutLine mInOutLine = new MInOutLine(this.getCtx(), 0, this.get_TrxName());
                mInOutLine.setM_InOut_ID(mInOut2.getM_InOut_ID());
                mInOutLine.setM_RMALine_ID(mInOutLineConfirmArray.getM_RMALine_ID());
                mInOutLine.setM_Product_ID(mInOutLineConfirmArray.getM_Product_ID());
                mInOutLine.setM_Locator_ID(((X_M_InOutLine)pO).getM_Locator_ID());
                mInOutLine.setMovementQty(mInOutLineConfirmArray.getQty());
                mInOutLine.saveEx();
            }
            mRMA.processIt("CO");
            mRMA.saveEx();
            this.addLog(mRMA.getDocumentInfo());
            if (mInOut2.getC_DocType().isShipConfirm() && this.isShipReceiptConfirmation()) {
                mInOut2.processIt("IP");
                mInOut2.saveEx();
                for (PO pO : mInOut2.getConfirmations(true)) {
                    for (MInOutLineConfirm mInOutLineConfirm : ((MInOutConfirm)pO).getLines(true)) {
                        mInOutLineConfirm.setConfirmedQty(mInOutLineConfirm.getTargetQty());
                        mInOutLineConfirm.saveEx();
                    }
                    ((MInOutConfirm)pO).processIt("CO");
                    pO.saveEx();
                    this.addLog(((MInOutConfirm)pO).getDocumentInfo());
                }
            }
            mInOut2.processIt("CO");
            mInOut2.saveEx();
            this.addLog(mInOut2.getDocumentInfo());
            this.customerReturns.add(mInOut2);
        }
    }

    private void cancelInvoices() {
        for (MInOut mInOut : this.customerReturns) {
            ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process("M_InOut_CreateInvoice").withTitle("Generate Invoice from Receipt").withRecordId(MInOut.Table_ID, mInOut.getM_InOut_ID()).withoutTransactionClose().execute(this.get_TrxName());
            if (processInfo.isError()) {
                String string = Msg.parseTranslation(this.getCtx(), processInfo.getTitle() + " @ProcessRunError@ " + processInfo.getSummary() + " " + processInfo.getLogInfo());
                throw new AdempierePOSException(string);
            }
            this.addLog(processInfo.getLogInfo());
            for (MInvoice mInvoice : this.getCreditNotes(mInOut.getM_RMA_ID())) {
                if (mInvoice == null || mInvoice.getC_Invoice_ID() <= 0) continue;
                mInvoice.setDateInvoiced(this.today);
                mInvoice.setDateAcct(this.today);
                mInvoice.processIt("CO");
                mInvoice.saveEx();
                this.addLog(mInvoice.getDocumentInfo());
            }
        }
    }

    public static List<MPayment> cancelPayments(MOrder mOrder, Timestamp timestamp) {
        ArrayList<MPayment> arrayList = new ArrayList<MPayment>();
        List<MPayment> list = MPayment.getOfOrder(mOrder);
        for (MPayment mPayment : list) {
            MPayment mPayment2 = new MPayment(mOrder.getCtx(), 0, mOrder.get_TrxName());
            PO.copyValues(mPayment, mPayment2);
            mPayment2.setDateTrx(timestamp);
            mPayment2.setC_Order_ID(mOrder.getC_Order_ID());
            mPayment2.setDateAcct(timestamp);
            mPayment2.addDescription(" @From@ " + mPayment.getDocumentNo());
            mPayment2.setIsReceipt(false);
            mPayment2.setC_DocType_ID(MDocType.getDocType("APP"));
            mPayment2.setDocAction("CO");
            mPayment2.setDocStatus("DR");
            mPayment2.setIsPrepayment(true);
            mPayment2.saveEx();
            mPayment2.processIt("CO");
            mPayment2.saveEx();
            arrayList.add(mPayment2);
        }
        return arrayList;
    }

    public int getRMATypeId() {
        return new Query(this.getCtx(), "M_RMAType", null, this.get_TrxName()).setOnlyActiveRecords(true).setOrderBy("Name").setClient_ID().firstId();
    }

    public List<MInvoice> getCreditNotes(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("M_RMA_ID").append("=?");
        return new Query(this.getCtx(), "C_Invoice", stringBuilder.toString(), this.get_TrxName()).setClient_ID().setParameters(n).list();
    }
}

