/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import org.adempiere.pos.process.CreateOrderBasedOnAnotherAbstract;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.util.Msg;

public class CreateOrderBasedOnAnother
extends CreateOrderBasedOnAnotherAbstract {
    private MOrder targetOrder;
    private Timestamp today;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.today = new Timestamp(System.currentTimeMillis());
        MOrder mOrder = new MOrder(this.getCtx(), this.getOrderSourceId(), this.get_TrxName());
        this.targetOrder = MOrder.copyFrom(mOrder, this.today, mOrder.getC_DocTypeTarget_ID(), mOrder.isSOTrx(), false, true, this.get_TrxName());
        if (this.getSOSubType() != null) {
            this.targetOrder.setC_DocTypeTarget_ID(MDocType.getDocTypeBaseOnSubType(mOrder.getAD_Org_ID(), "SOO", this.getSOSubType()));
        }
        this.targetOrder.setC_BPartner_ID(this.getInvoicePartnerId());
        this.targetOrder.setRef_Order_ID(mOrder.get_ID());
        this.targetOrder.setDocAction(this.getDocumentAction());
        this.targetOrder.setDocStatus("DR");
        this.targetOrder.setProcessed(false);
        this.targetOrder.saveEx();
        this.targetOrder.processIt(this.getDocumentAction());
        this.targetOrder.saveEx();
        this.addLog(this.targetOrder.getDocumentNo());
        this.getProcessInfo().setRecord_ID(this.targetOrder.get_ID());
        String string = "@C_Order_ID@ " + this.targetOrder.getDocumentNo();
        if (!this.targetOrder.isProcessed()) {
            return string;
        }
        if (this.isIncludePayments()) {
            this.createPayments(mOrder, this.targetOrder);
        }
        if (this.isAllocated()) {
            this.createAllocations(this.targetOrder);
        }
        return string;
    }

    private void createAllocations(MOrder mOrder) {
        List<MPayment> list = MPayment.getOfOrder(mOrder);
        MInvoice[] mInvoiceArray = mOrder.getInvoices();
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        for (MPayment mPayment : list) {
            bigDecimal = bigDecimal.add(mPayment.getPayAmt());
        }
        for (MInvoice mInvoice : mInvoiceArray) {
            bigDecimal2 = bigDecimal2.add(mInvoice.getGrandTotal());
        }
        if (bigDecimal2.signum() != 0 && bigDecimal.signum() != 0 && bigDecimal2.compareTo(bigDecimal) == 0) {
            MAllocationHdr mAllocationHdr = new MAllocationHdr(this.getCtx(), true, this.today, mOrder.getC_Currency_ID(), mOrder.getDescription(), this.get_TrxName());
            mAllocationHdr.setDocStatus("DR");
            mAllocationHdr.setDocAction("CO");
            mAllocationHdr.saveEx();
            this.addLog(mAllocationHdr.getDocumentInfo());
            for (MInvoice mInvoice : mInvoiceArray) {
                MAllocationLine mAllocationLine = new MAllocationLine(mAllocationHdr);
                mAllocationLine.setDocInfo(mOrder.getC_BPartner_ID(), mOrder.getC_Order_ID(), mInvoice.getC_Invoice_ID());
                mAllocationLine.setAmount(mInvoice.getGrandTotal());
                mAllocationLine.saveEx();
            }
            for (MPayment mPayment : list) {
                MAllocationLine mAllocationLine = new MAllocationLine(mAllocationHdr);
                mAllocationLine.setPaymentInfo(mPayment.get_ID(), 0);
                mAllocationLine.setAmount(mPayment.getPayAmt());
                mAllocationLine.saveEx();
            }
            mAllocationHdr.processIt("CO");
            mAllocationHdr.saveEx();
        }
    }

    private void createPayments(MOrder mOrder, MOrder mOrder2) {
        for (MPayment mPayment : MPayment.getOfOrder(mOrder)) {
            MPayment mPayment2 = new MPayment(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(mPayment, mPayment2);
            mPayment2.setDateTrx(this.today);
            mPayment2.setDateAcct(this.today);
            mPayment2.setC_Order_ID(mOrder2.getC_Order_ID());
            mPayment2.setC_BPartner_ID(mOrder2.getC_BPartner_ID());
            mPayment2.setC_Invoice_ID(-1);
            mPayment2.addDescription(Msg.parseTranslation(mOrder.getCtx(), " @From@ ") + mPayment.getDocumentNo());
            mPayment2.setIsReceipt(true);
            mPayment2.setC_DocType_ID(MDocType.getDocType("ARR", mOrder.getAD_Org_ID()));
            mPayment2.setIsPrepayment(true);
            mPayment2.saveEx();
            mPayment2.processIt(this.getDocumentAction());
            mPayment2.saveEx();
            this.addLog(mPayment2.getDocumentInfo());
        }
    }
}

