/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.process;

import java.util.LinkedHashMap;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.process.CloseStatementPOSAbstract;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.util.Msg;

public class CloseStatementPOS
extends CloseStatementPOSAbstract {
    protected LinkedHashMap<Integer, MBankStatement> baskStatements = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getBankAccountId() <= 0) {
            throw new AdempiereException("@C_BankAccount_ID@ @NotFound@");
        }
        if (this.getTransactionDate() == null || this.getTransactionDateTo() == null) {
            throw new AdempiereException("@DateTrx@ @NotFound@");
        }
        if (this.getDifference().signum() != 0 && !this.isOverUnderPayment()) {
            return Msg.parseTranslation(this.getCtx(), "@C_BankStatement_ID@ @NotApproved@ @NotMatch@");
        }
        if (this.isOverUnderPayment()) {
            if (this.getChargeId() <= 0) {
                throw new AdempiereException("@C_Charge_ID@ @NotFound@");
            }
            this.generateLostOrProfit();
        }
        this.closeBankStatements();
        return "@Ok@";
    }

    private void closeBankStatements() {
        this.getBankStatements().entrySet().stream().forEach(entry -> {
            MBankStatement mBankStatement = (MBankStatement)entry.getValue();
            mBankStatement.processIt("CO");
            mBankStatement.saveEx();
        });
    }

    private void generateLostOrProfit() {
        MBankStatement mBankStatement = (MBankStatement)((Object)this.getBankStatements().entrySet().iterator().next());
        MBankStatementLine mBankStatementLine = new MBankStatementLine(mBankStatement);
        mBankStatementLine.setDateAcct(this.getTransactionDate());
        mBankStatementLine.setStatementLineDate(this.getTransactionDateTo());
        mBankStatementLine.setStmtAmt(this.getDifference());
        mBankStatementLine.setC_Charge_ID(this.getChargeId());
        mBankStatementLine.setChargeAmt(this.getDifference());
        mBankStatementLine.saveEx();
    }

    private LinkedHashMap<Integer, MBankStatement> getBankStatements() {
        if (this.baskStatements != null && this.baskStatements.size() > 0) {
            return this.baskStatements;
        }
        this.baskStatements = new LinkedHashMap();
        List<?> list = this.getInstancesForSelection(this.get_TrxName());
        list.stream().forEach(mPayment -> {
            MBankStatementLine mBankStatementLine;
            MBankStatement mBankStatement;
            Integer n = this.getSelectionAsInt(mPayment.get_ID(), "BSL_C_BankStatementLine_ID");
            if (n != null && n > 0 && !this.baskStatements.containsKey((mBankStatement = (mBankStatementLine = new MBankStatementLine(this.getCtx(), n, this.get_TrxName())).getParent()).get_ID())) {
                this.baskStatements.put(mBankStatement.get_ID(), mBankStatement);
            }
        });
        return this.baskStatements;
    }
}

