/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFormattedTextField;
import org.adempiere.plaf.AdempierePLAF;
import org.adempiere.pos.POSKeyboard;
import org.compiere.apps.AEnv;

public class POSTextField
extends JFormattedTextField
implements MouseListener,
KeyListener {
    private static final long serialVersionUID = -2643611240006156141L;
    private POSKeyboard keyboard;
    private String placeHolder;
    private Font defaultFont = AdempierePLAF.getFont_Field().deriveFont(0, 16.0f);

    public POSTextField(String string, POSKeyboard pOSKeyboard) {
        this.keyboard = pOSKeyboard;
        if (this.keyboard != null) {
            this.addMouseListener(this);
        }
        this.setName(string);
    }

    public POSTextField(String string) {
        this(string, null);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isEnabled() && this.isEditable() && this.keyboard != null) {
            this.keyboard.setTitle(this.getName());
            this.keyboard.setPosTextField(this);
            AEnv.positionCenterScreen(this.keyboard);
            this.keyboard.setVisible(true);
            if (this.keyboard.isOk()) {
                this.fireActionPerformed();
            }
        }
    }

    public String getPlaceholder() {
        return this.placeHolder;
    }

    public void setPlaceholder(String string) {
        this.placeHolder = string;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.placeHolder == null || this.placeHolder.length() == 0 || this.getText().length() > 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.getDisabledTextColor());
        graphics2D.setFont(this.defaultFont);
        graphics2D.drawString(this.placeHolder, this.getMargin().left, this.getSize().height / 2 + this.getFont().getSize() / 2);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

