/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import javax.swing.Timer;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.service.POSScalesPanelInterface;
import org.adempiere.pos.service.driver.POSScalesDriver;
import org.adempiere.pos.service.driver.POSScalesDriverInterface;
import org.compiere.apps.ADialog;
import org.compiere.swing.CButton;

public class POSScalesListener
implements ActionListener,
KeyListener {
    private static boolean active = true;
    private POSScalesPanelInterface pos;
    private POSScalesDriverInterface driver;

    public POSScalesListener(POSScalesPanelInterface pOSScalesPanelInterface) {
        this.pos = pOSScalesPanelInterface;
        this.driver = new POSScalesDriver(pOSScalesPanelInterface.getElectronicScales(), pOSScalesPanelInterface.getMeasureRequestCode());
    }

    public static void setActive(boolean bl) {
        active = bl;
    }

    protected void doPerformAction(ActionEvent actionEvent) {
        if (((Timer)this.pos.getScalesTimer()).isRunning() && this.pos.getScalesTimer() != actionEvent.getSource()) {
            CButton cButton;
            if (actionEvent.getSource() instanceof CButton && (cButton = (CButton)actionEvent.getSource()).getName().equals("Ok")) {
                this.readMeasure();
                this.captureMeasure();
                return;
            }
            return;
        }
        if (actionEvent.getSource() == this.pos.getScalesTimer()) {
            this.readMeasure();
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (active) {
            try {
                this.doPerformAction(actionEvent);
            }
            catch (AdempiereException adempiereException) {
                ADialog.error(this.pos.getWindowNo(), null, adempiereException.getLocalizedMessage());
                throw new AdempiereException(adempiereException.getMessage());
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getComponent().toString().equals("Ok")) {
            this.readMeasure();
            this.captureMeasure();
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private BigDecimal getMeasure() {
        return this.driver.getMeasure();
    }

    public void readMeasure() {
        this.pos.setScalesMeasure(this.getMeasure().toString() + " " + this.pos.getProductUOMSymbol());
    }

    public void captureMeasure() {
        this.pos.setQty(this.getMeasure());
        this.pos.updateLineTable();
        this.pos.refreshPanel();
        this.pos.changeViewPanel();
        this.pos.hideScales();
        this.pos.showKeyboard();
        this.pos.getMainFocus();
        ((Timer)this.pos.getScalesTimer()).stop();
    }
}

