/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.TitledBorder;
import org.adempiere.plaf.AdempierePLAF;
import org.adempiere.pos.POSSubPanel;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.service.ProductInfo;
import org.compiere.model.MPOSKey;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class POSInfoProduct
extends POSSubPanel {
    private static final long serialVersionUID = 7670376798966290954L;
    private CButton buttonImage;
    private CLabel labelValue;
    private CLabel labelName;
    private CLabel labelUOMSymbol;
    private CLabel labelPriceName;
    private CLabel labelPriceLimit;
    private CLabel labelPrice;
    private CLabel labelPriceList;
    private CLabel labelProductCategory;
    private CLabel labelProductTax;
    private CLabel labelDescription;
    private CPanel rightPanel;
    private final int BUTTON_SIZE = 100;

    public POSInfoProduct(VPOS vPOS) {
        super(vPOS);
    }

    @Override
    protected void init() {
        this.setLayout(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(Msg.getMsg(Env.getCtx(), "InfoProduct"));
        titledBorder.setTitleFont(this.posPanel.getFont());
        titledBorder.setTitleColor(AdempierePLAF.getTextColor_Label());
        this.setBorder(titledBorder);
        FontMetrics fontMetrics = this.getFontMetrics(this.posPanel.getPlainFont());
        this.rightPanel = new CPanel(new GridBagLayout());
        this.labelName = new CLabel(Msg.getElement(Env.getCtx(), "ProductName"));
        this.labelName.setFont(this.posPanel.getBigFont());
        this.labelName.setHorizontalAlignment(2);
        this.rightPanel.add((Component)this.labelName, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.labelPriceName = new CLabel(Msg.parseTranslation(this.ctx, "@PriceStd@ , @PriceList@ ") + this.posPanel.getCurSymbol());
        this.labelPriceName.setFont(this.posPanel.getBigFont());
        this.labelPriceName.setHorizontalAlignment(2);
        this.labelPriceName.setHorizontalTextPosition(2);
        this.rightPanel.add((Component)this.labelPriceName, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.labelPrice = new CLabel(this.posPanel.getNumberFormat().format(Env.ZERO));
        this.labelPrice.setFont(this.posPanel.getBigFont());
        this.labelPrice.setHorizontalAlignment(4);
        this.labelPrice.setHorizontalTextPosition(4);
        this.labelPrice.setPreferredSize(new Dimension(100, fontMetrics.getHeight()));
        this.labelPrice.setMinimumSize(new Dimension(150, fontMetrics.getHeight()));
        this.rightPanel.add((Component)this.labelPrice, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.labelPriceList = new CLabel(this.posPanel.getNumberFormat().format(Env.ZERO));
        this.labelPriceList.setFont(this.posPanel.getBigFont());
        this.labelPriceList.setHorizontalAlignment(4);
        this.labelPriceList.setHorizontalTextPosition(4);
        this.labelPriceList.setPreferredSize(new Dimension(100, fontMetrics.getHeight()));
        this.labelPriceList.setMinimumSize(new Dimension(150, fontMetrics.getHeight()));
        this.rightPanel.add((Component)this.labelPriceList, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.labelValue = new CLabel(Msg.getElement(Env.getCtx(), "ProductValue"));
        this.labelValue.setFont(this.posPanel.getPlainFont());
        this.labelValue.setHorizontalAlignment(2);
        this.labelValue.setHorizontalTextPosition(2);
        this.rightPanel.add((Component)this.labelValue, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.labelUOMSymbol = new CLabel(Msg.getElement(Env.getCtx(), "C_UOM_ID"));
        this.labelUOMSymbol.setFont(this.posPanel.getPlainFont());
        this.labelUOMSymbol.setHorizontalAlignment(2);
        this.labelUOMSymbol.setHorizontalTextPosition(2);
        this.rightPanel.add((Component)this.labelUOMSymbol, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.labelProductCategory = new CLabel(Msg.getElement(Env.getCtx(), "M_Product_Category_ID"));
        this.labelProductCategory.setFont(this.posPanel.getPlainFont());
        this.labelProductCategory.setHorizontalAlignment(2);
        this.rightPanel.add((Component)this.labelProductCategory, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.labelProductTax = new CLabel(Msg.getElement(Env.getCtx(), "C_TaxCategory_ID"));
        this.labelProductTax.setFont(this.posPanel.getPlainFont());
        this.labelProductTax.setHorizontalAlignment(2);
        this.rightPanel.add((Component)this.labelProductTax, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.labelDescription = new CLabel(Msg.getElement(Env.getCtx(), "Description"));
        this.labelDescription.setFont(this.posPanel.getPlainFont());
        this.labelDescription.setHorizontalAlignment(2);
        this.labelDescription.setPreferredSize(new Dimension(20, fontMetrics.getHeight()));
        this.labelDescription.setMaximumSize(new Dimension(20, fontMetrics.getHeight()));
        this.rightPanel.add((Component)this.labelDescription, new GridBagConstraints(0, 6, 2, 1, 0.0, 1.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonImage = new CButton();
        this.buttonImage.setFont(this.posPanel.getFont());
        this.buttonImage.setPreferredSize(new Dimension(100, 100));
        this.buttonImage.setMinimumSize(new Dimension(100, 100));
        this.buttonImage.setFocusable(false);
        this.buttonImage.setVerticalTextPosition(3);
        this.buttonImage.setHorizontalTextPosition(0);
        this.add((Component)this.buttonImage, new GridBagConstraints(0, 0, 1, 1, 0.1, 1.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.rightPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
    }

    private void setValuesFromProduct(int n, BigDecimal bigDecimal, int n2, int n3, int n4) {
        if (n <= 0) {
            return;
        }
        this.labelPriceName.setText(Msg.parseTranslation(this.ctx, "@PriceStd@ , @PriceList@ ") + this.posPanel.getCurSymbol());
        ProductInfo productInfo = new ProductInfo(n, bigDecimal, n2, n3, n4);
        this.labelValue.setText(productInfo.value);
        this.labelPrice.setText(this.posPanel.getNumberFormat().format(productInfo.priceStd));
        this.labelPriceList.setText(this.posPanel.getNumberFormat().format(productInfo.priceList));
        this.labelName.setText(productInfo.name);
        this.labelUOMSymbol.setText(productInfo.uomSymbol);
        this.labelProductCategory.setText(productInfo.productCategoryName);
        this.labelProductTax.setText(productInfo.productTaxCategory);
        this.posPanel.updateProductPlaceholder(productInfo.name);
        String string = productInfo.description;
        if (string == null) {
            string = "-";
        }
        this.labelDescription.setText(string.trim());
        if (productInfo.imageData != null) {
            try {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(productInfo.imageData));
                Image image = bufferedImage.getScaledInstance(100, 100, 4);
                this.buttonImage.setIcon(new ImageIcon(image));
            }
            catch (IOException iOException) {}
        } else {
            this.buttonImage.setIcon(null);
            this.buttonImage.invalidate();
        }
    }

    public void refreshProduct(MPOSKey mPOSKey, BigDecimal bigDecimal, int n, int n2) {
        if (mPOSKey == null) {
            return;
        }
        this.setValuesFromProduct(mPOSKey.getM_Product_ID(), bigDecimal, mPOSKey.getAD_Image_ID(), n, n2);
    }

    public void refreshProduct(int n, BigDecimal bigDecimal, int n2, int n3) {
        int n4 = this.posPanel.getProductImageId(n, this.posPanel.getC_POSKeyLayout_ID());
        this.setValuesFromProduct(n, bigDecimal, n4, n2, n3);
    }

    public void resetValues() {
        this.labelValue.setText("--");
        this.labelPriceName.setText("--");
        this.labelPrice.setText("--");
        this.labelPriceList.setText("--");
        this.labelName.setText("--");
        this.labelUOMSymbol.setText("--");
        this.labelProductCategory.setText("--");
        this.labelProductTax.setText("--");
        this.labelDescription.setText("--");
        this.buttonImage.setIcon(null);
        this.buttonImage.invalidate();
    }

    public String getUOMSymbol() {
        return this.labelUOMSymbol.getText();
    }
}

