/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.compiere.Adempiere;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DistFileElementHandler
extends AbstractElementHandler {
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        int AD_Backup_ID = -1;
        String Object_Status = null;
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("name"));
        String releaseNumber = atts.getValue("ReleaseNo");
        if (releaseNumber == null || Adempiere.MAIN_VERSION.equals(releaseNumber) || releaseNumber.equals("all")) {
            int success;
            OutputStream outputStream;
            FileInputStream inputStream;
            boolean success2;
            String fileName = atts.getValue("name");
            String sourceDirectory = atts.getValue("sourceDirectory");
            String targetDirectory = atts.getValue("targetDirectory");
            Object_Status = "New";
            int idDetail = 0;
            String packagePath = null;
            String adempiereSourcePath = null;
            try {
                packagePath = this.getPackageDirectory(ctx);
                File parentDirectory = new File(packagePath);
                while (!parentDirectory.getName().equals("packages")) {
                    parentDirectory = parentDirectory.getParentFile();
                }
                parentDirectory = parentDirectory.getParentFile();
                adempiereSourcePath = parentDirectory.getCanonicalPath();
            }
            catch (IOException e1) {
                System.out.println("Can't find adempiere-all directory.");
            }
            File backupDir = new File(packagePath + File.separator + "backup" + File.separator);
            if (!backupDir.exists() && !(success2 = new File(packagePath + File.separator + "backup" + File.separator).mkdirs())) {
                this.log.info("Backup directory creation failed");
            }
            String fullTargetPath = adempiereSourcePath + targetDirectory;
            char slash1 = '\\';
            char slash2 = '/';
            fullTargetPath = File.separator.equals("/") ? fullTargetPath.replace(slash1, slash2) : fullTargetPath.replace(slash2, slash1);
            File file = new File(fullTargetPath + fileName);
            boolean force = true;
            String fileDate = null;
            if (file.exists() && !force) {
                System.out.println("Output file exists.  Use the -f option to replace it.");
                return;
            }
            if (file.exists() && force) {
                Object_Status = "Update";
                this.log.info("Target Backup:" + fullTargetPath + fileName);
                inputStream = this.OpenInputfile(fullTargetPath + fileName);
                SimpleDateFormat formatter_file = new SimpleDateFormat("yyMMddHHmmssSSSSZ");
                Date today = new Date();
                fileDate = formatter_file.format(today);
                outputStream = this.OpenOutputfile(packagePath + File.separator + "backup" + File.separator + fileDate + "_" + fileName);
                this.log.info("Source Backup:" + packagePath + File.separator + "backup" + File.separator + fileDate + "_" + fileName);
                this.copyFile(inputStream, outputStream);
                this.log.info("Backup Complete");
            }
            String fullSourcePath = null;
            fullSourcePath = File.separator.equals("/") ? sourceDirectory.replace(slash1, slash2) : sourceDirectory.replace(slash2, slash1);
            inputStream = this.OpenInputfile(packagePath + fullSourcePath + fileName);
            File targetDir = new File(fullTargetPath);
            if (!targetDir.exists() && (success = new File(fullTargetPath).mkdirs()) == 0) {
                this.log.info("Target directory creation failed");
            }
            outputStream = this.OpenOutputfile(fullTargetPath + fileName);
            success = this.copyFile(inputStream, outputStream);
            int idBackup = DB.getNextID(this.getClientId(ctx), "AD_Package_Imp_Backup", this.getTrxName(ctx));
            if (success != -1) {
                try {
                    idDetail = this.recordLog(ctx, 1, fileName, "file", 0, 0, Object_Status, fileName, 0);
                }
                catch (SAXException e) {
                    this.log.info("setfile:" + e);
                }
            } else {
                try {
                    idDetail = this.recordLog(ctx, 0, fileName, "file", 0, 0, Object_Status, fileName, 0);
                }
                catch (SAXException e) {
                    this.log.info("setfile:" + e);
                }
            }
            StringBuffer sqlB = new StringBuffer("INSERT INTO AD_Package_Imp_Backup").append("(AD_Client_ID, AD_Org_ID, CreatedBy, UpdatedBy, ").append("AD_PACKAGE_IMP_BACKUP_ID, AD_PACKAGE_IMP_DETAIL_ID, AD_PACKAGE_IMP_ID,").append(" AD_PACKAGE_IMP_ORG_DIR, AD_PACKAGE_IMP_BCK_DIR)").append("VALUES(").append(" " + Env.getAD_Client_ID(ctx)).append(", " + Env.getAD_Org_ID(ctx)).append(", " + Env.getAD_User_ID(ctx)).append(", " + Env.getAD_User_ID(ctx)).append(", " + idBackup).append(", " + idDetail).append(", " + this.getPackageImpId(ctx)).append(", '" + fullTargetPath + fileName).append("', '" + packagePath + File.separator + "backup" + File.separator + fileDate + "_" + fileName).append("')");
            int no = DB.executeUpdate(sqlB.toString(), this.getTrxName(ctx));
            if (no == -1) {
                this.log.info("Insert to import backup failed");
            }
        }
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        String FileName = Env.getContext(ctx, "FileName");
        String Source_Directory = Env.getContext(ctx, "Source_Directory");
        String Target_Directory = Env.getContext(ctx, "Target_Directory");
        String ReleaseNo = Env.getContext(ctx, "ReleaseNo");
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "name", "CDATA", FileName);
        atts.addAttribute("", "", "sourceDirectory", "CDATA", Source_Directory);
        atts.addAttribute("", "", "targetDirectory", "CDATA", Target_Directory);
        atts.addAttribute("", "", "ReleaseNo", "CDATA", ReleaseNo);
        document.startElement("", "", "distfile", atts);
        document.endElement("", "", "distfile");
    }
}

