/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.adempiere.pipo.CreateZipFile;
import org.adempiere.pipo.IDFinder;
import org.adempiere.pipo.PackInAbstract;
import org.adempiere.pipo.PackInHandler;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.X_AD_Package_Imp_Proc;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Trx;
import org.spin.util.XMLUtils;
import org.xml.sax.helpers.DefaultHandler;

public class PackIn
extends PackInAbstract {
    private CLogger log = CLogger.getCLogger("PackIn");
    public static boolean updateMode = true;
    public static String database = "Oracle";
    public static String packageDirectory = null;
    public static boolean isRequiresSync = true;

    public String importXML(String fileName, Properties ctx, String trxName) throws Exception {
        this.log.info("importXML:" + fileName);
        File in = new File(fileName);
        if (!in.exists()) {
            String msg = "File does not exist: " + fileName;
            this.log.info("importXML:" + msg);
            return msg;
        }
        try {
            this.log.info("starting");
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
            PackInHandler handler = new PackInHandler();
            handler.set_TrxName(trxName);
            handler.setCtx(ctx);
            handler.setProcess(this);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLUtils.setDefaultFeatures(factory);
            SAXParser parser = factory.newSAXParser();
            String msg = "Start Parser";
            this.log.info(msg);
            parser.parse(in, (DefaultHandler)handler);
            msg = "End Parser";
            this.log.info(msg);
            return "OK.";
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "importXML:", e);
            throw e;
        }
    }

    @Override
    protected String doIt() throws Exception {
        boolean success;
        File targetDir;
        X_AD_Package_Imp_Proc packageToImport = new X_AD_Package_Imp_Proc(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        IDFinder.clearIDCache();
        String packageDirectory = packageToImport.getAD_Package_Dir();
        if (packageDirectory == null || packageDirectory.trim().length() == 0) {
            packageDirectory = Adempiere.getAdempiereHome();
        }
        if (!(targetDir = new File(packageDirectory + File.separator + "packages")).exists() && !(success = new File(packageDirectory + File.separator + "packages").mkdirs())) {
            this.log.info("Target directory creation failed");
        }
        File zipFilepath = new File(packageToImport.getAD_Package_Source());
        this.log.info("zipFilepath->" + zipFilepath);
        String PackageName = CreateZipFile.getParentDir(zipFilepath);
        CreateZipFile.unpackFile(zipFilepath, targetDir);
        String dict_file = packageDirectory + File.separator + "packages" + File.separator + PackageName + File.separator + "dict" + File.separator + "PackOut.xml";
        this.log.info("dict file->" + dict_file);
        PackIn packIn = new PackIn();
        updateMode = packageToImport.isAD_Override_Dict();
        isRequiresSync = packageToImport.isRequiresSync();
        PackIn.packageDirectory = packageDirectory + File.separator + "packages" + File.separator + PackageName + File.separator;
        if (DB.isOracle()) {
            database = "Oracle";
        } else if (DB.isPostgreSQL()) {
            database = "PostgreSQL";
        }
        String msg = packIn.importXML(dict_file, this.getCtx(), this.get_TrxName());
        return msg;
    }

    public static void main(String[] args) {
        block18: {
            if (args.length < 1) {
                System.out.println("Please give the file name to read as first parameter.");
                System.exit(1);
            }
            String file = args[0];
            Adempiere.startup(true);
            if (args.length > 8 && args[8].equals("AdempiereSys")) {
                System.out.println("**** WARNING: Working with system sequences AdempiereSys ****");
                Ini.setProperty("AdempiereSys", true);
            }
            PackIn packIn = new PackIn();
            if (args.length >= 6) {
                CConnection cc = CConnection.get();
                database = cc.getType();
                DB.setDBTarget(cc);
            }
            Level logLevel = Level.FINER;
            switch (Integer.parseInt(args[6])) {
                case 1: {
                    logLevel = Level.OFF;
                    break;
                }
                case 2: {
                    logLevel = Level.SEVERE;
                    break;
                }
                case 3: {
                    logLevel = Level.WARNING;
                    break;
                }
                case 4: {
                    logLevel = Level.INFO;
                    break;
                }
                case 5: {
                    logLevel = Level.CONFIG;
                    break;
                }
                case 6: {
                    logLevel = Level.FINE;
                    break;
                }
                case 7: {
                    logLevel = Level.FINER;
                    break;
                }
                case 8: {
                    logLevel = Level.FINEST;
                    break;
                }
                case 9: {
                    logLevel = Level.ALL;
                }
            }
            CLogMgt.setLevel(logLevel);
            CLogMgt.setLoggerLevel(logLevel, null);
            if (args.length >= 8) {
                updateMode = args[7] == "true";
            }
            String trxName = Trx.createTrxName("PackIn");
            try {
                packIn.importXML(file, Env.getCtx(), trxName);
                Trx trx = Trx.get(trxName, false);
                if (trx != null) {
                    trx.commit(true);
                }
            }
            catch (Exception e) {
                System.out.println("Import Failed: " + e.getLocalizedMessage());
                Trx trx = Trx.get(trxName, false);
                if (trx == null) break block18;
                trx.rollback();
            }
        }
        System.exit(0);
    }
}

