/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.model.MView;
import org.adempiere.model.MViewColumn;
import org.adempiere.model.X_AD_View_Definition;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;

public class MViewDefinition
extends X_AD_View_Definition {
    private static final long serialVersionUID = 8557695983263069806L;
    private static CLogger s_log = CLogger.getCLogger(MViewDefinition.class);
    private static CCache<Integer, MViewDefinition> s_cache = new CCache("AD_View_Definition", 100);
    private MView m_view = null;
    private MTable m_table = null;

    public static MViewDefinition get(Properties ctx, int AD_View_Definition_ID) {
        if (AD_View_Definition_ID <= 0) {
            return null;
        }
        MViewDefinition definition = s_cache.get(AD_View_Definition_ID);
        if (definition != null) {
            return definition;
        }
        definition = new MViewDefinition(ctx, AD_View_Definition_ID, null);
        if (definition.get_ID() == AD_View_Definition_ID) {
            s_cache.put(AD_View_Definition_ID, definition);
        } else {
            definition = null;
        }
        return definition;
    }

    public MViewDefinition(Properties ctx, int AD_View_Definition_ID, String trxName) {
        super(ctx, AD_View_Definition_ID, trxName);
        if (AD_View_Definition_ID == 0) {
            // empty if block
        }
    }

    public MViewDefinition(Properties ctx, int AD_View_Definition_ID) {
        this(ctx, AD_View_Definition_ID, null);
    }

    public MViewDefinition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MViewDefinition[").append(this.get_ID()).append("-").append("").append("]");
        return sb.toString();
    }

    @Override
    public MView getAD_View() {
        if (this.m_view == null) {
            this.m_view = (MView)super.getAD_View();
        }
        return this.m_view;
    }

    @Override
    public MTable getAD_Table() {
        if (this.m_table == null) {
            this.m_table = MTable.get(this.getCtx(), this.getAD_Table_ID());
        }
        return this.m_table;
    }

    public String getSelectClause() {
        StringBuffer selectClause = new StringBuffer();
        List<MColumn> atts = this.getEntityAttributes();
        for (MColumn attr : atts) {
            selectClause.append(this.getTableAlias()).append(attr.getColumnName()).append(",");
        }
        return selectClause.toString();
    }

    public List<MColumn> getEntityAttributes() {
        String whereClause = "AD_Table_ID=? AND NOT EXISTS(SELECT 1 FROM AD_View_Column WHERE AD_View_Column.AD_Column_ID=AD_Column.AD_Column_ID AND AD_View_Column.AD_View_Definition_ID=?)";
        return new Query(this.getCtx(), "AD_Column", "AD_Table_ID=? AND NOT EXISTS(SELECT 1 FROM AD_View_Column WHERE AD_View_Column.AD_Column_ID=AD_Column.AD_Column_ID AND AD_View_Column.AD_View_Definition_ID=?)", this.get_TrxName()).setParameters(this.getAD_Table_ID(), this.getAD_View_Definition_ID()).setOnlyActiveRecords(true).list();
    }

    public List<MViewColumn> getADViewColumns() {
        String whereClause = "AD_View_Definition_ID=?";
        return new Query(this.getCtx(), "AD_View_Column", "AD_View_Definition_ID=?", this.get_TrxName()).setParameters(this.getAD_View_Definition_ID()).list();
    }
}

