/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.excel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import org.adempiere.util.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.compiere.model.MImage;
import org.compiere.model.ReportTO;
import org.compiere.report.MReportColumn;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SmjXlsReport {
    public CLogger log = CLogger.getCLogger(SmjXlsReport.class);
    private int cols = 0;
    private short endRegion = (short)2;

    public HSSFWorkbook generate(LinkedList<ReportTO> data, String[] generalTitle, String clientName, String clientNIT, String periodName, String currencyName, MReportColumn[] m_columns, String city, Integer logoId) {
        int fila = 0;
        this.cols = m_columns.length + 2;
        this.endRegion = (short)(this.cols - 1);
        try {
            HSSFRow row;
            HSSFWorkbook book = new HSSFWorkbook();
            HSSFSheet sheet = book.createSheet(StringUtils.makePrefix(generalTitle[0]));
            HSSFFont font = book.createFont();
            font.setFontHeightInPoints((short)13);
            font.setFontName("Arial");
            font.setBold(true);
            HSSFCellStyle cellStyle = book.createCellStyle();
            cellStyle.setWrapText(true);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
            cellStyle.setFont(font);
            if (logoId > 0) {
                MImage mimage = MImage.get(Env.getCtx(), logoId);
                byte[] imageData = mimage.getData();
                HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
                HSSFClientAnchor anchor = new HSSFClientAnchor(100, 50, 200, 255, 0, 0, 1, 1);
                anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
                int pictureIndex = book.addPicture(imageData, 6);
                patriarch.createPicture(anchor, pictureIndex);
                for (int i = 0; i < 5; ++i) {
                    row = sheet.createRow(fila++);
                }
            }
            row = sheet.createRow(fila++);
            HSSFRichTextString text = new HSSFRichTextString(generalTitle[0]);
            HSSFCell cell = row.createCell(0);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
            CellRangeAddress region = new CellRangeAddress(fila - 1, 0, fila - 1, (int)this.endRegion);
            sheet.addMergedRegion(region);
            row = sheet.createRow(fila++);
            text = new HSSFRichTextString(clientName);
            cell = row.createCell(0);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
            region = new CellRangeAddress(fila - 1, 0, fila - 1, (int)this.endRegion);
            sheet.addMergedRegion(region);
            row = sheet.createRow(fila++);
            text = new HSSFRichTextString(city);
            cell = row.createCell(0);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
            region = new CellRangeAddress(fila - 1, 0, fila - 1, (int)this.endRegion);
            sheet.addMergedRegion(region);
            row = sheet.createRow(fila++);
            text = new HSSFRichTextString(clientNIT);
            cell = row.createCell(0);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
            region = new CellRangeAddress(fila - 1, 0, fila - 1, (int)this.endRegion);
            sheet.addMergedRegion(region);
            String pn = "";
            pn = generalTitle[1] != null && generalTitle[1].length() > 0 ? generalTitle[1] + " " + periodName : periodName;
            if (generalTitle[2] != null && generalTitle[2].length() > 0) {
                pn = pn + " " + generalTitle[2];
            }
            row = sheet.createRow(fila++);
            text = new HSSFRichTextString(pn);
            cell = row.createCell(0);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
            region = new CellRangeAddress(fila - 1, 0, fila - 1, (int)this.endRegion);
            sheet.addMergedRegion(region);
            row = sheet.createRow(fila++);
            text = new HSSFRichTextString(currencyName);
            cell = row.createCell(0);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
            region = new CellRangeAddress(fila - 1, 0, fila - 1, (int)this.endRegion);
            sheet.addMergedRegion(region);
            row = sheet.createRow(fila++);
            this.titleTable(book, sheet, fila++, m_columns);
            this.reportTable(book, data, sheet, fila);
            return book;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void titleTable(HSSFWorkbook book, HSSFSheet sheet, int fila, MReportColumn[] m_columns) {
        int col = 0;
        HSSFFont font = book.createFont();
        font.setFontHeightInPoints((short)13);
        font.setFontName("Arial");
        font.setBold(true);
        HSSFCellStyle cellStyle = book.createCellStyle();
        cellStyle.setWrapText(true);
        cellStyle.setAlignment(HorizontalAlignment.JUSTIFY);
        cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
        cellStyle.setFont(font);
        HSSFRow row = sheet.createRow(fila);
        HSSFRichTextString text = new HSSFRichTextString(Msg.translate(Env.getCtx(), "name").toUpperCase());
        int n = col;
        col = (short)(col + 1);
        HSSFCell cell = row.createCell(n);
        cell.setCellStyle(cellStyle);
        cell.setCellType(1);
        cell.setCellValue((RichTextString)text);
        text = new HSSFRichTextString(Msg.translate(Env.getCtx(), "description").toUpperCase());
        int n2 = col;
        col = (short)(col + 1);
        cell = row.createCell(n2);
        cell.setCellStyle(cellStyle);
        cell.setCellType(1);
        cell.setCellValue((RichTextString)text);
        for (MReportColumn mcol : m_columns) {
            String colName = mcol.getName();
            text = new HSSFRichTextString(colName.toUpperCase());
            int n3 = col;
            col = (short)(col + 1);
            cell = row.createCell(n3);
            cell.setCellStyle(cellStyle);
            cell.setCellType(1);
            cell.setCellValue((RichTextString)text);
        }
    }

    public void reportTable(HSSFWorkbook book, LinkedList<ReportTO> data, HSSFSheet sheet, int fila) {
        HSSFFont font = book.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName("Arial");
        Iterator itRep = data.iterator();
        Boolean newRow = false;
        sheet.setColumnWidth(0, 3328);
        sheet.setColumnWidth(1, 15360);
        for (int i = 2; i < this.cols; ++i) {
            sheet.setColumnWidth((int)((short)i), 3840);
        }
        HSSFCellStyle cellStyle = book.createCellStyle();
        HSSFCellStyle cellStyleD = book.createCellStyle();
        HSSFCellStyle cellStyleN = book.createCellStyle();
        while (itRep.hasNext()) {
            HSSFRichTextString text;
            HSSFRow row;
            int col = 0;
            ReportTO rpt = (ReportTO)itRep.next();
            if (!newRow.booleanValue()) {
                cellStyle = book.createCellStyle();
                cellStyleD = book.createCellStyle();
                cellStyleN = book.createCellStyle();
            }
            newRow = false;
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("T")) {
                row = sheet.createRow(fila++);
                HSSFFont fontT = book.createFont();
                fontT.setFontHeightInPoints((short)12);
                fontT.setFontName("Arial");
                fontT.setBold(true);
                HSSFCellStyle cellStyleT = book.createCellStyle();
                cellStyleT.setWrapText(true);
                cellStyleT.setAlignment(HorizontalAlignment.CENTER);
                cellStyleT.setVerticalAlignment(VerticalAlignment.TOP);
                cellStyleT.setFont(fontT);
                CellRangeAddress region = new CellRangeAddress(fila - 1, 0, fila - 1, (int)this.endRegion);
                sheet.addMergedRegion(region);
                text = new HSSFRichTextString(rpt.getDescription());
                HSSFCell cellT = row.createCell(col);
                cellT.setCellStyle(cellStyleT);
                cellT.setCellValue((RichTextString)text);
                newRow = true;
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("L")) {
                cellStyle.setWrapText(true);
                cellStyle.setBorderTop(BorderStyle.MEDIUM);
                cellStyle.setBottomBorderColor((short)8);
                cellStyleD.setWrapText(true);
                cellStyleD.setBorderTop(BorderStyle.MEDIUM);
                cellStyleD.setBottomBorderColor((short)8);
                cellStyleN.setWrapText(true);
                cellStyleN.setBorderTop(BorderStyle.MEDIUM);
                cellStyleN.setBottomBorderColor((short)8);
                newRow = true;
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("X")) {
                cellStyle.setWrapText(true);
                cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
                cellStyle.setBorderTop(BorderStyle.MEDIUM);
                cellStyle.setBottomBorderColor((short)8);
                newRow = true;
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("Z")) {
                cellStyle.setWrapText(true);
                cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
                cellStyle.setBorderTop(BorderStyle.DOUBLE);
                cellStyle.setBottomBorderColor((short)8);
                row = sheet.createRow(fila++);
                ReportTO rptD = new ReportTO();
                this.putRow(cellStyle, cellStyleD, cellStyleN, sheet, row, fila, rptD);
                cellStyle = book.createCellStyle();
                newRow = true;
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("D")) {
                cellStyleD.setWrapText(true);
                cellStyleD.setVerticalAlignment(VerticalAlignment.TOP);
                cellStyleD.setBorderTop(BorderStyle.MEDIUM);
                cellStyleD.setBottomBorderColor((short)8);
                newRow = true;
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("S")) {
                row = sheet.createRow(fila++);
                newRow = true;
                continue;
            }
            if (rpt.getTablevel() != null && rpt.getTablevel() > 0) {
                row = sheet.createRow(fila++);
                String jerarchy = "";
                for (int i = 1; i <= rpt.getTablevel(); ++i) {
                    jerarchy = jerarchy + "   ";
                }
                CellRangeAddress region = new CellRangeAddress(fila - 1, 0, fila - 1, (int)this.endRegion);
                sheet.addMergedRegion(region);
                text = new HSSFRichTextString(jerarchy + rpt.getDescription());
                HSSFCell cellJ = row.createCell(col);
                cellJ.setCellValue((RichTextString)text);
                newRow = true;
                continue;
            }
            row = sheet.createRow(fila++);
            this.putRow(cellStyle, cellStyleD, cellStyleN, sheet, row, fila, rpt);
        }
    }

    private void putRow(HSSFCellStyle cellStyle, HSSFCellStyle cellStyleD, HSSFCellStyle cellStyleN, HSSFSheet sheet, HSSFRow row, int fila, ReportTO rpt) {
        int col = 0;
        cellStyle.setAlignment(HorizontalAlignment.RIGHT);
        HSSFRichTextString text = new HSSFRichTextString(rpt.getName());
        int n = col;
        col = (short)(col + 1);
        HSSFCell cell = row.createCell(n);
        cell.setCellStyle(cellStyleN);
        cell.setCellValue((RichTextString)text);
        text = new HSSFRichTextString(rpt.getDescription());
        cell.setCellStyle(cellStyleD);
        int n2 = col;
        col = (short)(col + 1);
        cell = row.createCell(n2);
        cell.setCellValue((RichTextString)text);
        if (this.cols >= 3) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_0()));
            int n3 = col;
            col = (short)(col + 1);
            cell = row.createCell(n3);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 4) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_1()));
            int n4 = col;
            col = (short)(col + 1);
            cell = row.createCell(n4);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 5) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_2()));
            int n5 = col;
            col = (short)(col + 1);
            cell = row.createCell(n5);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 6) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_3()));
            int n6 = col;
            col = (short)(col + 1);
            cell = row.createCell(n6);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 7) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_4()));
            int n7 = col;
            col = (short)(col + 1);
            cell = row.createCell(n7);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 8) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_5()));
            int n8 = col;
            col = (short)(col + 1);
            cell = row.createCell(n8);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 9) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_6()));
            int n9 = col;
            col = (short)(col + 1);
            cell = row.createCell(n9);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 10) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_7()));
            int n10 = col;
            col = (short)(col + 1);
            cell = row.createCell(n10);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 11) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_8()));
            int n11 = col;
            col = (short)(col + 1);
            cell = row.createCell(n11);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 12) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_9()));
            int n12 = col;
            col = (short)(col + 1);
            cell = row.createCell(n12);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 13) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_10()));
            int n13 = col;
            col = (short)(col + 1);
            cell = row.createCell(n13);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 14) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_11()));
            int n14 = col;
            col = (short)(col + 1);
            cell = row.createCell(n14);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 15) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_12()));
            int n15 = col;
            col = (short)(col + 1);
            cell = row.createCell(n15);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 16) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_13()));
            int n16 = col;
            col = (short)(col + 1);
            cell = row.createCell(n16);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 17) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_14()));
            int n17 = col;
            col = (short)(col + 1);
            cell = row.createCell(n17);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 18) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_15()));
            int n18 = col;
            col = (short)(col + 1);
            cell = row.createCell(n18);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 19) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_16()));
            int n19 = col;
            col = (short)(col + 1);
            cell = row.createCell(n19);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 20) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_17()));
            int n20 = col;
            col = (short)(col + 1);
            cell = row.createCell(n20);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 21) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_18()));
            int n21 = col;
            col = (short)(col + 1);
            cell = row.createCell(n21);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 22) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_19()));
            int n22 = col;
            col = (short)(col + 1);
            cell = row.createCell(n22);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
        if (this.cols >= 23) {
            text = new HSSFRichTextString(this.formatValue(rpt.getCol_20()));
            int n23 = col;
            col = (short)(col + 1);
            cell = row.createCell(n23);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((RichTextString)text);
        }
    }

    public File tofile(HSSFWorkbook wb, String[] generalTitle) {
        String path = System.getProperty("java.io.tmpdir");
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + System.getProperty("file.separator");
        }
        String prefix = StringUtils.makePrefix(generalTitle[0]);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
        }
        File file = new File(path + prefix + ".xls");
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "file", e);
            return null;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            wb.write((OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    private String formatValue(BigDecimal data) {
        if (data == null) {
            return "";
        }
        DecimalFormat frm = new DecimalFormat("###,###,###,##0.00");
        return frm.format(data.setScale(2, 4));
    }
}

