/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.adempiere.engine.AbstractCostingMethod;
import org.adempiere.engine.CostComponent;
import org.adempiere.engine.CostDimension;
import org.adempiere.engine.CostEngine;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.IDocumentLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_AD_WF_Node;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MDocType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.MPPOrderBOMLine;
import org.eevolution.model.MPPOrderCost;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;

public class StandardCostingMethod
extends AbstractCostingMethod
implements ICostingMethod {
    @Override
    public void setCostingMethod(MAcctSchema accountSchema, MTransaction transaction, IDocumentLine model, MCost dimension, BigDecimal costThisLevel, BigDecimal costLowLevel, Boolean isSalesTransaction) {
        this.accountSchema = accountSchema;
        this.transaction = transaction;
        this.dimension = dimension;
        this.costThisLevel = costThisLevel == null ? Env.ZERO : costThisLevel;
        this.costLowLevel = costLowLevel == null ? Env.ZERO : costLowLevel;
        this.isSalesTransaction = isSalesTransaction;
        this.model = transaction.getDocumentLine();
        this.costingLevel = MProduct.get(this.transaction.getCtx(), this.transaction.getM_Product_ID()).getCostingLevel(this.accountSchema, this.transaction.getAD_Org_ID());
        this.costDetail = MCostDetail.getByTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID());
        this.movementQuantity = transaction.getMovementQty();
        MDocType documentType = new MDocType(transaction.getCtx(), transaction.getDocumentLine().getC_DocType_ID(), transaction.get_TrxName());
        this.isOpenPeriod = MPeriod.isOpen(transaction.getCtx(), model.getDateAcct(), documentType.getDocBaseType(), transaction.getAD_Org_ID());
        this.dateAccounting = this.isOpenPeriod != false ? model.getDateAcct() : (model instanceof MLandedCostAllocation ? ((MLandedCostAllocation)model).getC_InvoiceLine().getC_Invoice().getDateAcct() : (model instanceof MMatchInv ? ((MMatchInv)model).getC_InvoiceLine().getC_Invoice().getDateAcct() : null));
    }

    private void calculate() {
        if (this.model.getReversalLine_ID() > 0 && !this.model.isReversalParent()) {
            return;
        }
        this.lastCostDetail = MCostDetail.getLastTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.dateAccounting, this.costingLevel);
        if (this.lastCostDetail == null) {
            this.lastCostDetail = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), Env.ZERO, Env.ZERO, Env.ZERO, this.transaction.get_TrxName());
            this.lastCostDetail.setDateAcct(this.dateAccounting);
        }
        if (this.movementQuantity.signum() < 0) {
            this.currentCostPrice = this.dimension.getCurrentCostPrice();
            this.currentCostPriceLowerLevel = this.dimension.getCurrentCostPriceLL();
            this.amount = this.movementQuantity.multiply(this.currentCostPrice);
            this.amountLowerLevel = this.movementQuantity.multiply(this.currentCostPriceLowerLevel);
            this.accumulatedQuantity = this.dimension.getCumulatedQty().add(this.movementQuantity);
            this.accumulatedAmount = this.dimension.getCumulatedAmt().add(this.amount);
            this.accumulatedAmountLowerLevel = this.dimension.getCumulatedAmtLL().add(this.amountLowerLevel);
            return;
        }
        if (this.costDetail != null) {
            this.amount = this.movementQuantity.multiply(this.costDetail.getCurrentCostPrice());
            this.amountLowerLevel = this.movementQuantity.multiply(this.costDetail.getCurrentCostPriceLL());
            this.accumulatedQuantity = this.costDetail.getCumulatedQty().add(this.movementQuantity);
            this.accumulatedAmount = this.costDetail.getCumulatedAmt().add(this.amount);
            this.accumulatedAmountLowerLevel = this.costDetail.getCumulatedAmtLL().add(this.amountLowerLevel);
            this.currentCostPrice = this.dimension.getCurrentCostPrice();
            this.currentCostPriceLowerLevel = this.dimension.getCurrentCostPriceLL();
            this.adjustCost = this.currentCostPrice.multiply(this.dimension.getCumulatedQty()).subtract(this.dimension.getCumulatedAmt());
            this.adjustCost = this.currentCostPriceLowerLevel.multiply(this.dimension.getCumulatedQty()).subtract(this.dimension.getCumulatedAmtLL());
            return;
        }
        this.amount = this.movementQuantity.multiply(this.dimension.getCurrentCostPrice());
        this.amountLowerLevel = this.movementQuantity.multiply(this.dimension.getCurrentCostPriceLL());
        this.accumulatedAmount = this.dimension.getCumulatedAmt().add(this.amount).add(this.adjustCost);
        this.accumulatedAmountLowerLevel = this.dimension.getCumulatedAmtLL().add(this.amountLowerLevel).add(this.adjustCostLowerLevel);
        this.accumulatedQuantity = this.dimension.getCumulatedQty().add(this.movementQuantity);
        this.currentCostPrice = this.dimension.getCurrentCostPrice();
        this.currentCostPriceLowerLevel = this.dimension.getCurrentCostPriceLL();
    }

    private void createCostDetail() {
        CharSequence description;
        String idColumnName = CostEngine.getIDColumnName(this.model);
        if (this.model.getReversalLine_ID() > 0 && !this.model.isReversalParent()) {
            this.createReversalCostDetail();
            return;
        }
        int seqNo = this.lastCostDetail.getSeqNo() + 10;
        if (this.model instanceof MPPCostCollector) {
            MPPCostCollector cc = (MPPCostCollector)this.model;
            if ("130".equals(cc.getCostCollectorType())) {
                this.createMethodVariances(cc);
            } else if ("120".equals(cc.getCostCollectorType())) {
                this.createUsageVariances(cc);
            } else if ("140".equals(cc.getCostCollectorType())) {
                this.createRateVariances(cc);
            } else if ("150".equals(cc.getCostCollectorType())) {
                // empty if block
            }
        }
        if (this.costDetail == null) {
            this.costDetail = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.currentCostPrice.multiply(this.movementQuantity).abs(), this.currentCostPriceLowerLevel.multiply(this.movementQuantity).abs(), this.movementQuantity, this.transaction.get_TrxName());
            this.costDetail.setDateAcct(this.dateAccounting);
            this.costDetail.setSeqNo(seqNo);
        }
        if (this.adjustCost.signum() != 0 || this.adjustCostLowerLevel.signum() != 0) {
            CharSequence charSequence = description = this.costDetail.getDescription() != null ? this.costDetail.getDescription() : "";
            if (this.adjustCost.signum() != 0) {
                this.costDetail.setCostAdjustmentDate(this.model.getDateAcct());
                this.costDetail.setCostAdjustment(this.adjustCost);
                this.costDetail.setAmt(this.costDetail.getAmt().add(this.costDetail.getCostAdjustment()));
                this.costDetail.setDescription((String)description + " Adjust Cost:" + this.adjustCost);
            }
            if (this.adjustCostLowerLevel.signum() != 0) {
                description = this.costDetail.getDescription() != null ? this.costDetail.getDescription() : "";
                this.costDetail.setCostAdjustmentDateLL(this.model.getDateAcct());
                this.costDetail.setCostAdjustmentLL(this.adjustCostLowerLevel);
                this.costDetail.setAmtLL(this.costDetail.getCostAmtLL().add(this.costDetail.getCostAdjustmentLL()));
                this.costDetail.setDescription((String)description + " Adjust Cost LL:" + this.adjustCost);
            }
        }
        if (!this.costDetail.set_ValueOfColumnReturningBoolean(idColumnName, (Object)this.model.get_ID())) {
            throw new AdempiereException("Cannot set " + idColumnName);
        }
        if (this.isSalesTransaction != null) {
            this.costDetail.setIsSOTrx(this.isSalesTransaction);
        } else {
            this.costDetail.setIsSOTrx(this.model.isSOTrx());
        }
        if (this.transaction != null) {
            this.costDetail.setM_Transaction_ID(this.transaction.getM_Transaction_ID());
        }
        this.costDetail.setCumulatedQty(this.dimension.getCumulatedQty());
        this.costDetail.setCumulatedAmt(this.dimension.getCumulatedAmt());
        this.costDetail.setCumulatedAmtLL(this.dimension.getCumulatedAmtLL());
        this.costDetail.setCurrentCostPrice(this.dimension.getCurrentCostPrice());
        this.costDetail.setCurrentCostPriceLL(this.dimension.getCurrentCostPriceLL());
        description = new StringBuilder();
        if (!Util.isEmpty(this.model.getDescription(), true)) {
            ((StringBuilder)description).append(this.model.getDescription());
        }
        if (this.isSalesTransaction != null) {
            ((StringBuilder)description).append(this.isSalesTransaction != false ? "(|->)" : "(|<-)");
        }
        if (this.transaction != null) {
            this.costDetail.setM_Transaction_ID(this.transaction.getM_Transaction_ID());
        }
        this.costDetail.setDescription(((StringBuilder)description).toString());
        this.updateAmountCost();
        this.costDetail.saveEx();
    }

    public void createCostAdjustment() {
    }

    @Override
    public MCostDetail process() {
        this.calculate();
        this.createCostDetail();
        this.updateInventoryValue();
        this.createCostAdjustment();
        return this.costDetail;
    }

    @Override
    public BigDecimal getNewCurrentCostPrice(MCostDetail cost, int scale, int roundingMode) {
        if (this.getNewAccumulatedQuantity(cost).signum() != 0 && this.getNewAccumulatedAmount(cost).signum() != 0) {
            return this.getNewAccumulatedAmount(cost).divide(this.getNewAccumulatedQuantity(cost), scale, roundingMode);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNewAccumulatedAmount(MCostDetail cost) {
        BigDecimal accumulatedAmount = Env.ZERO;
        if (cost.getQty().signum() > 0) {
            accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt()).add(cost.getCostAdjustment());
        } else if (cost.getQty().signum() < 0) {
            accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt().negate()).add(cost.getCostAdjustment().negate());
        } else if (cost.getQty().signum() == 0) {
            if (this.getNewAccumulatedQuantity(cost).signum() > 0) {
                accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt()).add(cost.getCostAdjustment());
            } else if (this.getNewAccumulatedQuantity(cost).signum() < 0) {
                accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt().negate()).add(cost.getCostAdjustment().negate());
            }
        }
        return accumulatedAmount;
    }

    @Override
    public BigDecimal getNewAccumulatedAmountLowerLevel(MCostDetail cost) {
        BigDecimal accumulatedAmountLowerLevel = Env.ZERO;
        if (cost.getQty().signum() >= 0) {
            accumulatedAmountLowerLevel = cost.getCumulatedAmtLL().add(cost.getCostAmtLL()).add(cost.getCostAdjustmentLL());
        } else if (cost.getQty().signum() < 0) {
            accumulatedAmountLowerLevel = cost.getCumulatedAmtLL().add(cost.getCostAmtLL().negate()).add(cost.getCostAdjustmentLL().negate());
        } else if (cost.getQty().signum() == 0) {
            if (this.getNewAccumulatedQuantity(cost).signum() > 0) {
                accumulatedAmountLowerLevel = cost.getCumulatedAmt().add(cost.getCostAmtLL()).add(cost.getCostAdjustmentLL());
            } else if (this.getNewAccumulatedQuantity(cost).signum() < 0) {
                accumulatedAmountLowerLevel = cost.getCumulatedAmt().add(cost.getCostAmtLL().negate()).add(cost.getCostAdjustmentLL().negate());
            }
        }
        return accumulatedAmountLowerLevel;
    }

    @Override
    public BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail cost, int scale, int roundingMode) {
        if (this.getNewAccumulatedQuantity(cost).signum() != 0 && this.getNewAccumulatedAmountLowerLevel(cost).signum() != 0) {
            return this.getNewAccumulatedAmountLowerLevel(cost).divide(this.getNewAccumulatedQuantity(cost), scale, roundingMode);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNewAccumulatedQuantity(MCostDetail cost) {
        return cost.getCumulatedQty().add(cost.getQty());
    }

    @Override
    protected List<CostComponent> getCalculatedCosts() {
        return null;
    }

    @Override
    public void updateAmountCost() {
        if (this.movementQuantity.signum() > 0) {
            this.costDetail.setCostAmt(this.costDetail.getAmt().subtract(this.costDetail.getCostAdjustment()));
            this.costDetail.setCostAmtLL(this.costDetail.getAmtLL().subtract(this.costDetail.getCostAdjustmentLL()));
        } else if (this.movementQuantity.signum() < 0) {
            this.costDetail.setCostAmt(this.costDetail.getAmt().add(this.adjustCost));
            this.costDetail.setCostAmtLL(this.costDetail.getAmtLL().add(this.adjustCostLowerLevel));
        }
        this.costDetail.setCumulatedQty(this.getNewAccumulatedQuantity(this.lastCostDetail));
        this.costDetail.setCumulatedAmt(this.getNewAccumulatedAmount(this.lastCostDetail));
        this.costDetail.setCumulatedAmtLL(this.getNewAccumulatedAmountLowerLevel(this.lastCostDetail));
        this.costDetail.setCurrentCostPrice(this.currentCostPrice);
        this.costDetail.setCurrentCostPriceLL(this.currentCostPriceLowerLevel);
        String idColumnName = CostEngine.getIDColumnName(this.model);
        this.costDetail.set_ValueOfColumn(idColumnName, (Object)CostEngine.getIDColumn(this.model));
        if (this.model instanceof MInOutLine) {
            MInOutLine ioLine = (MInOutLine)this.model;
            this.costDetail.setC_OrderLine_ID(ioLine.getC_OrderLine_ID());
            this.costDetail.setC_InvoiceLine_ID(0);
        }
        if (this.model instanceof MMatchInv && this.costDetail.getM_InOutLine_ID() == 0) {
            MMatchInv iMatch = (MMatchInv)this.model;
            this.costDetail.setM_InOutLine_ID(iMatch.getM_InOutLine_ID());
        }
        if (this.model instanceof MMatchPO && this.costDetail.getM_InOutLine_ID() == 0) {
            MMatchPO poMatch = (MMatchPO)this.model;
            this.costDetail.setM_InOutLine_ID(poMatch.getM_InOutLine_ID());
        }
        if (this.model instanceof MLandedCostAllocation) {
            MLandedCostAllocation allocation = (MLandedCostAllocation)this.model;
            this.costDetail.setM_InOutLine_ID(allocation.getM_InOutLine_ID());
            this.costDetail.setC_InvoiceLine_ID(allocation.getC_InvoiceLine_ID());
            this.costDetail.setC_LandedCostAllocation_ID(allocation.getC_LandedCostAllocation_ID());
            this.costDetail.setProcessed(false);
        }
        this.costDetail.saveEx();
    }

    @Override
    public void updateInventoryValue() {
        this.dimension.setCumulatedAmt(this.accumulatedAmount);
        this.dimension.setCumulatedAmtLL(this.accumulatedAmountLowerLevel);
        this.dimension.setCumulatedQty(this.accumulatedQuantity);
        this.dimension.setCurrentQty(this.accumulatedQuantity);
        this.dimension.saveEx();
    }

    public BigDecimal getResourceStandardCostRate(MPPCostCollector cc, int S_Resource_ID, CostDimension d, String trxName) {
        MProduct resourceProduct = MProduct.forS_Resource_ID(Env.getCtx(), S_Resource_ID, null);
        return this.getProductStandardCostPrice(cc, resourceProduct, MAcctSchema.get(Env.getCtx(), d.getC_AcctSchema_ID()), MCostElement.get(Env.getCtx(), d.getM_CostElement_ID()));
    }

    public BigDecimal getProductStandardCostPrice(MPPCostCollector cc, MProduct product, MAcctSchema as, MCostElement element) {
        CostDimension d = new CostDimension(product, as, as.getM_CostType_ID(), 0, 0, 0, element.getM_CostElement_ID());
        MPPOrderCost oc = (MPPOrderCost)d.toQuery(MPPOrderCost.class, "PP_Order_ID=?", new Object[]{cc.getPP_Order_ID()}, cc.get_TrxName()).firstOnly();
        if (oc == null) {
            return Env.ZERO;
        }
        BigDecimal costs = oc.getCurrentCostPrice().add(oc.getCurrentCostPriceLL());
        return CostEngine.roundCost(costs, as.getC_AcctSchema_ID());
    }

    public void createRateVariances(MPPCostCollector costCollector) {
        MProduct product = null;
        if (costCollector.isCostCollectorType("160")) {
            I_AD_WF_Node node = costCollector.getPP_Order_Node().getAD_WF_Node();
            product = MProduct.forS_Resource_ID(costCollector.getCtx(), node.getS_Resource_ID(), null);
        } else if (costCollector.isCostCollectorType("110")) {
            MPPOrderBOMLine bomLine = costCollector.getPP_Order_BOMLine();
            product = MProduct.get(costCollector.getCtx(), bomLine.getM_Product_ID());
        } else if ("140".equals(costCollector.getCostCollectorType())) {
            product = MProduct.get(costCollector.getCtx(), costCollector.getM_Product_ID());
        }
        MPPCostCollector costCollectorRateVariance = null;
        for (MAcctSchema accountSchema : CostEngine.getAcctSchema(costCollector)) {
            for (MCostElement costElement : MCostElement.getCostElement(costCollector.getCtx(), costCollector.get_TrxName())) {
                BigDecimal amtActual;
                MCostDetail cost = MCostDetail.getCostDetail(costCollector, costElement.getM_CostElement_ID());
                if (cost == null) continue;
                BigDecimal quantity = cost.getQty();
                BigDecimal priceStandard = this.getProductStandardCostPrice(costCollector, product, accountSchema, costElement);
                BigDecimal priceActual = StandardCostingMethod.getProductActualCostPrice(costCollector, product, accountSchema, costElement, costCollector.get_TrxName());
                BigDecimal amountStandard = CostEngine.roundCost(priceStandard.multiply(quantity), accountSchema.getC_AcctSchema_ID());
                if (amountStandard.compareTo(amtActual = CostEngine.roundCost(priceActual.multiply(quantity), accountSchema.getC_AcctSchema_ID())) == 0) continue;
                if (costCollectorRateVariance == null) {
                    costCollectorRateVariance = MPPCostCollector.createVarianceCostCollector(costCollector, "140");
                }
                List<MCostType> costTypes = MCostType.get(accountSchema.getCtx(), accountSchema.get_TrxName());
                for (MCostType costType : costTypes) {
                    this.createVarianceCostDetail(costCollectorRateVariance, amtActual.abs(), quantity, cost, null, accountSchema, costType, costElement);
                    this.createVarianceCostDetail(costCollectorRateVariance, amountStandard.abs(), quantity, cost, null, accountSchema, costType, costElement);
                }
            }
        }
        if (costCollectorRateVariance != null) {
            boolean ok = costCollectorRateVariance.processIt("CO");
            costCollectorRateVariance.saveEx();
            if (!ok) {
                throw new AdempiereException(costCollectorRateVariance.getProcessMsg());
            }
        }
    }

    public void createMethodVariances(MPPCostCollector costCollector) {
        int actual_resource_id;
        if (!costCollector.isCostCollectorType("160")) {
            return;
        }
        int std_resource_id = costCollector.getPP_Order_Node().getAD_WF_Node().getS_Resource_ID();
        if (std_resource_id == (actual_resource_id = costCollector.getS_Resource_ID())) {
            return;
        }
        MPPCostCollector methodChangeVariance = null;
        RoutingService routingService = RoutingServiceFactory.get().getRoutingService(costCollector.getAD_Client_ID());
        for (MAcctSchema as : CostEngine.getAcctSchema(costCollector)) {
            for (MCostElement element : MCostElement.getCostElement(costCollector.getCtx(), costCollector.get_TrxName())) {
                BigDecimal priceActual;
                MProduct resourcePStd = MProduct.forS_Resource_ID(costCollector.getCtx(), std_resource_id, null);
                MProduct resourcePActual = MProduct.forS_Resource_ID(costCollector.getCtx(), actual_resource_id, null);
                BigDecimal priceStd = StandardCostingMethod.getProductActualCostPrice(costCollector, resourcePStd, as, element, costCollector.get_TrxName());
                if (priceStd.compareTo(priceActual = StandardCostingMethod.getProductActualCostPrice(costCollector, resourcePActual, as, element, costCollector.get_TrxName())) == 0) continue;
                if (methodChangeVariance == null) {
                    methodChangeVariance = MPPCostCollector.createVarianceCostCollector(costCollector, "130");
                }
                BigDecimal qty = routingService.getResourceBaseValue(costCollector.getS_Resource_ID(), costCollector);
                BigDecimal amtStd = priceStd.multiply(qty);
                BigDecimal amtActual = priceActual.multiply(qty);
                List<MCostType> costtypes = MCostType.get(as.getCtx(), as.get_TrxName());
                for (MCostType costType : costtypes) {
                    if (!"S".equals(costType.getCostingMethod())) continue;
                    this.createVarianceCostDetail(methodChangeVariance, amtActual.abs(), qty, null, resourcePActual, as, costType, element);
                    this.createVarianceCostDetail(methodChangeVariance, amtStd.negate(), qty.negate(), null, resourcePStd, as, costType, element);
                }
            }
        }
        if (methodChangeVariance != null) {
            boolean ok = methodChangeVariance.processIt("CO");
            methodChangeVariance.saveEx();
            if (!ok) {
                throw new AdempiereException(methodChangeVariance.getProcessMsg());
            }
        }
    }

    public MCostDetail createVarianceCostDetail(MPPCostCollector costCollector, BigDecimal amount, BigDecimal quantity, MCostDetail cost, MProduct product, MAcctSchema accountSchema, MCostType costType, MCostElement costElement) {
        MCostDetail costDetailVariance = new MCostDetail(costCollector.getCtx(), 0, costCollector.get_TrxName());
        if (cost != null) {
            MCostDetail.copyValues(cost, costDetailVariance);
            costDetailVariance.setProcessed(false);
        }
        if (product != null) {
            costDetailVariance.setM_Product_ID(product.getM_Product_ID());
            costDetailVariance.setM_AttributeSetInstance_ID(costCollector.getM_AttributeSetInstance_ID());
        }
        if (accountSchema != null) {
            costDetailVariance.setC_AcctSchema_ID(accountSchema.getC_AcctSchema_ID());
        }
        if (costElement != null) {
            costDetailVariance.setM_CostElement_ID(costElement.getM_CostElement_ID());
        }
        costDetailVariance.setPP_Cost_Collector_ID(costCollector.getPP_Cost_Collector_ID());
        costDetailVariance.setM_CostType_ID(costType.getM_CostType_ID());
        costDetailVariance.setM_CostElement_ID(costElement.getM_CostElement_ID());
        costDetailVariance.setAmt(amount);
        costDetailVariance.setCostAmt(amount);
        costDetailVariance.setAmtLL(BigDecimal.ZERO);
        costDetailVariance.setQty(quantity);
        costDetailVariance.setDateAcct(costCollector.getDateAcct());
        costDetailVariance.saveEx();
        return costDetailVariance;
    }

    public void createActivityControl(MPPCostCollector costCollector) {
        if (!costCollector.isCostCollectorType("160")) {
            return;
        }
        MProduct product = MProduct.forS_Resource_ID(costCollector.getCtx(), costCollector.getS_Resource_ID(), null);
        RoutingService routingService = RoutingServiceFactory.get().getRoutingService(costCollector.getAD_Client_ID());
        BigDecimal quantity = routingService.getResourceBaseValue(costCollector.getS_Resource_ID(), costCollector);
        for (MAcctSchema accountSchema : CostEngine.getAcctSchema(costCollector)) {
            for (MCostElement costElement : MCostElement.getCostElement(costCollector.getCtx(), costCollector.get_TrxName())) {
                if (!CostEngine.isActivityControlElement(costElement)) continue;
                CostDimension dimension = new CostDimension(product, accountSchema, accountSchema.getM_CostType_ID(), costCollector.getAD_Org_ID(), costCollector.getM_Warehouse_ID(), costCollector.getM_AttributeSetInstanceTo_ID(), costElement.getM_CostElement_ID());
                BigDecimal price = StandardCostingMethod.getResourceActualCostRate(costCollector.getS_Resource_ID(), dimension, costCollector.get_TrxName());
                BigDecimal costs = price.multiply(quantity);
                if (costs.scale() > accountSchema.getCostingPrecision()) {
                    costs = costs.setScale(accountSchema.getCostingPrecision(), RoundingMode.HALF_UP);
                }
                List<MCostType> costTypes = MCostType.get(accountSchema.getCtx(), accountSchema.get_TrxName());
                for (MCostType costType : costTypes) {
                    if (!"S".equals(costType.getCostingMethod())) continue;
                    MCostDetail cost = new MCostDetail(accountSchema, costCollector.getAD_Org_ID(), dimension.getM_Product_ID(), 0, costElement.getM_CostElement_ID(), costs.negate(), quantity.negate(), costElement.getName(), costCollector.get_TrxName(), costType.getM_CostType_ID());
                    cost.setPP_Cost_Collector_ID(costCollector.getPP_Cost_Collector_ID());
                    cost.setDateAcct(costCollector.getDateAcct());
                    cost.setCostAmt(costs.negate());
                    cost.saveEx();
                }
            }
        }
    }

    public void createUsageVariances(MPPCostCollector usageVariance) {
        BigDecimal quantity;
        MProduct product;
        if (!usageVariance.isCostCollectorType("120")) {
            throw new IllegalArgumentException("Cost Collector is not Material Usage Variance");
        }
        if (usageVariance.getPP_Order_BOMLine_ID() > 0) {
            product = MProduct.get(usageVariance.getCtx(), usageVariance.getM_Product_ID());
            quantity = usageVariance.getMovementQty();
        } else {
            product = MProduct.forS_Resource_ID(usageVariance.getCtx(), usageVariance.getS_Resource_ID(), null);
            RoutingService routingService = RoutingServiceFactory.get().getRoutingService(usageVariance.getAD_Client_ID());
            quantity = routingService.getResourceBaseValue(usageVariance.getS_Resource_ID(), usageVariance);
        }
        for (MAcctSchema accountSchema : CostEngine.getAcctSchema(usageVariance)) {
            for (MCostElement element : MCostElement.getCostElement(usageVariance.getCtx(), usageVariance.get_TrxName())) {
                BigDecimal price = StandardCostingMethod.getProductActualCostPrice(usageVariance, product, accountSchema, element, usageVariance.get_TrxName());
                BigDecimal amt = CostEngine.roundCost(price.multiply(quantity), accountSchema.getC_AcctSchema_ID());
                if (amt.compareTo(Env.ZERO) == 0) continue;
                List<MCostType> costTypes = MCostType.get(accountSchema.getCtx(), accountSchema.get_TrxName());
                for (MCostType costType : costTypes) {
                    this.createVarianceCostDetail(usageVariance, amt.abs(), quantity, null, product, accountSchema, costType, element);
                }
            }
        }
    }

    public static BigDecimal getResourceActualCostRate(int resourceId, CostDimension costDimension, String trxName) {
        if (resourceId <= 0) {
            return Env.ZERO;
        }
        MProduct resourceProduct = MProduct.forS_Resource_ID(Env.getCtx(), resourceId, trxName);
        CostDimension resourcecCostDimension = new CostDimension(costDimension.setM_Product(resourceProduct));
        MCost cost = (MCost)resourcecCostDimension.toQuery(MCost.class, trxName).firstOnly();
        if (cost == null) {
            return Env.ZERO;
        }
        BigDecimal price = cost.getCurrentCostPrice().add(cost.getCurrentCostPriceLL());
        return CostEngine.roundCost(price, resourcecCostDimension.getC_AcctSchema_ID());
    }

    public static BigDecimal getProductActualCostPrice(MPPCostCollector costCollector, MProduct product, MAcctSchema acctSchema, MCostElement element, String trxName) {
        String costingLevel = product.getCostingLevel(acctSchema);
        int orgId = 0;
        int warehouseId = 0;
        int attributeSetInstanceId = 0;
        if (costCollector != null) {
            orgId = costCollector.getAD_Org_ID();
            warehouseId = costCollector.getM_Warehouse_ID();
            attributeSetInstanceId = costCollector.getM_AttributeSetInstance_ID();
        }
        if ("C".equals(costingLevel)) {
            orgId = 0;
            attributeSetInstanceId = 0;
            warehouseId = 0;
        } else if ("O".equals(costingLevel)) {
            attributeSetInstanceId = 0;
            warehouseId = 0;
        } else if ("W".equals(costingLevel)) {
            attributeSetInstanceId = 0;
        } else if ("B".equals(costingLevel)) {
            orgId = 0;
            warehouseId = 0;
        }
        CostDimension costDimension = new CostDimension(product, acctSchema, acctSchema.getM_CostType_ID(), orgId, warehouseId, attributeSetInstanceId, element.getM_CostElement_ID());
        MCost cost = (MCost)costDimension.toQuery(MCost.class, trxName).firstOnly();
        if (cost == null) {
            return Env.ZERO;
        }
        BigDecimal price = cost.getCurrentCostPrice().add(cost.getCurrentCostPriceLL());
        return CostEngine.roundCost(price, acctSchema.getC_AcctSchema_ID());
    }
}

