/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.util.HashMap;
import java.util.Map;
import org.adempiere.engine.AverageInvoiceCostingMethod;
import org.adempiere.engine.AveragePOCostingMethod;
import org.adempiere.engine.FifoLifoCostingMethod;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.LastInvoiceCostingMethod;
import org.adempiere.engine.LastPOPriceCostingMethod;
import org.adempiere.engine.StandardCostingMethod;
import org.adempiere.exceptions.AdempiereException;

public class CostingMethodFactory {
    private static final CostingMethodFactory s_instance = new CostingMethodFactory();
    private static final Map<String, Class<? extends ICostingMethod>> s_map = new HashMap<String, Class<? extends ICostingMethod>>();

    public static CostingMethodFactory get() {
        return s_instance;
    }

    private CostingMethodFactory() {
    }

    public ICostingMethod getCostingMethod(String costingMethod) {
        ICostingMethod cm;
        Class<? extends ICostingMethod> cl = s_map.get(costingMethod);
        if (cl == null) {
            throw new AdempiereException("No implementation found for costing method " + costingMethod);
        }
        try {
            cm = cl.newInstance();
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        return cm;
    }

    static {
        s_map.put("F", FifoLifoCostingMethod.class);
        s_map.put("L", FifoLifoCostingMethod.class);
        s_map.put("I", AverageInvoiceCostingMethod.class);
        s_map.put("A", AveragePOCostingMethod.class);
        s_map.put("i", LastInvoiceCostingMethod.class);
        s_map.put("p", LastPOPriceCostingMethod.class);
        s_map.put("S", StandardCostingMethod.class);
    }
}

