/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.controller.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.controller.form.BOMDropForm;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.ValueChangeEvent;
import org.adempiere.exceptions.ValueChangeListener;
import org.compiere.model.MColumn;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.MValRule;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CEditor;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class BOMDropController
implements ValueChangeListener,
VetoableChangeListener {
    private BOMDropForm form;
    private ProcessInfo processInfo;
    private PO po = null;
    private CEditor productEditor;
    private CEditor productQtyEditor;
    private CEditor explodeBomEditor;
    private CEditor orderEditor;
    private CEditor invoiceEditor;
    private CEditor projectEditor;
    private boolean isSwing = true;
    private int m_product_id;
    private MProduct product;
    private HashMap<String, Object> knownFeatures = new HashMap();
    public ArrayList<Selection> selectionList = new ArrayList();
    private static final String MSG_NothingSelected = "BOMDropController_NothingSelected";
    private static final String MSG_ItemSelectedSingular = "BOMDropController_ItemSelectedSingular";
    private static final String MSG_ItemSelectedPlural = "BOMDropController_ItemSelectedPlural";
    private static final String MSG_ExplodeBOM = "BOMDropController_ExplodeBOM";
    private static final String MSG_ExplodeBOMTooltip = "BOMDropController_ExplodeBOMTooltip";
    private static final String MSG_IsExplodeBOMName = "BOMDropController_ExplodeBOM";
    private static final String MSG_BOMListHeaderProduct = "@M_Product_ID@";
    private static final String MSG_BOMListHeaderQty = "@Qty@";
    private static final String MSG_BOMListHeaderUOM = "@C_UOM_ID@";
    private static final String EDITORTYPE_CHECK = "CHECK";
    private static final String EDITORTYPE_QTY = "QTY";
    private static final String EDITORTYPE_UOM = "UOM";
    CLogger log = CLogger.getCLogger(BOMDropController.class);
    Properties ctx;
    private int windowNo;
    private String trxName;
    private boolean canExplodeBOM;

    public BOMDropController(BOMDropForm form) {
        this.form = form;
        this.ctx = Env.getCtx();
    }

    private void setProcessInfo(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public boolean init(ProcessInfo processInfo, int windowNo) {
        this.setProcessInfo(processInfo);
        this.windowNo = windowNo;
        if (!this.checkProcessInfo()) {
            return false;
        }
        int ad_column_id = MColumn.getColumn_ID("M_Product", "M_Product_ID");
        String name = Msg.translate(this.ctx, "M_Product_ID");
        String validationCode = "IsBOM='Y' AND IsVerified='Y'";
        MLookup productLookup = null;
        try {
            productLookup = MLookupFactory.get(this.ctx, windowNo, ad_column_id, 19, Env.getLanguage(this.ctx), "M_Product_ID", 0, false, validationCode);
        }
        catch (Exception e) {
            this.log.severe("Unable to load product lookup: " + e.getLocalizedMessage());
            return false;
        }
        int row = 0;
        this.product = null;
        this.m_product_id = 0;
        this.productEditor = this.form.createSelectionEditor(19, productLookup, "", name, "", row, 0);
        this.productEditor.setValue(null);
        this.productEditor.setMandatory(true);
        this.productEditor.setBackground(true);
        this.addListener(this.productEditor);
        this.productQtyEditor = this.form.createSelectionEditor(29, null, Msg.translate(this.ctx, "Qty"), Msg.translate(this.ctx, "Qty"), "", row++, 2);
        this.productQtyEditor.setValue(Env.ONE);
        this.addListener(this.productQtyEditor);
        String explodeBOMName = Msg.translate(this.ctx, "BOMDropController_ExplodeBOM");
        String explodeBOMDesc = Msg.translate(this.ctx, MSG_ExplodeBOMTooltip);
        String isExplodeBOMName = Msg.translate(this.ctx, "BOMDropController_ExplodeBOM");
        this.explodeBomEditor = this.form.createSelectionEditor(20, null, isExplodeBOMName, explodeBOMName, explodeBOMDesc, row++, 1);
        this.explodeBomEditor.setValue(new Boolean(false));
        this.addListener(this.explodeBomEditor);
        if (this.po == null) {
            validationCode = "Processed='N' AND (DocStatus='DR' OR DocStatus='IP')";
            MLookup lookup = null;
            try {
                lookup = MLookupFactory.get(this.ctx, windowNo, MColumn.getColumn_ID("C_Order", "C_Order_ID"), 19, Env.getLanguage(this.ctx), "C_Order_ID", 0, false, validationCode);
            }
            catch (Exception e) {
                this.log.severe("Unable to load order lookup: " + e.getLocalizedMessage());
                return false;
            }
            name = Msg.translate(this.ctx, "C_Order_ID");
            this.orderEditor = this.form.createSelectionEditor(19, lookup, "", name, "", row++, 0);
            this.orderEditor.setMandatory(true);
            this.orderEditor.setBackground(true);
            this.addListener(this.orderEditor);
            try {
                lookup = MLookupFactory.get(this.ctx, windowNo, MColumn.getColumn_ID("C_Invoice", "C_Invoice_ID"), 19, Env.getLanguage(this.ctx), "C_Invoice_ID", 0, false, validationCode);
            }
            catch (Exception e) {
                this.log.severe("Unable to load invoice lookup: " + e.getLocalizedMessage());
                return false;
            }
            name = Msg.translate(this.ctx, "C_Invoice_ID");
            this.invoiceEditor = this.form.createSelectionEditor(19, lookup, "", name, "", row++, 0);
            this.invoiceEditor.setMandatory(true);
            this.invoiceEditor.setBackground(true);
            this.addListener(this.invoiceEditor);
            validationCode = "Processed='N' AND IsSummary='N' AND IsActive='Y' AND ProjectCategory<>'S'";
            lookup = null;
            try {
                lookup = MLookupFactory.get(this.ctx, windowNo, MColumn.getColumn_ID("C_Project", "C_Project_ID"), 19, Env.getLanguage(this.ctx), "C_Project_ID", 0, false, validationCode);
            }
            catch (Exception e) {
                this.log.severe("Unable to load project lookup: " + e.getLocalizedMessage());
                return false;
            }
            name = Msg.translate(this.ctx, "C_Project_ID");
            this.projectEditor = this.form.createSelectionEditor(19, lookup, "", name, "", row++, 0);
            this.projectEditor.setMandatory(true);
            this.projectEditor.setBackground(true);
            this.addListener(this.projectEditor);
        }
        this.enableConfirmOK();
        return true;
    }

    private boolean checkProcessInfo() {
        if (this.processInfo == null || this.processInfo.getInterfaceType().equals(ProcessInfo.INTERFACE_TYPE_NOT_SET)) {
            StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
            for (int i = 1; i < stElements.length; ++i) {
                StackTraceElement ste = stElements[i];
                if (!ste.getClassName().contains("webui") && !ste.getClassName().contains("zk.ui")) continue;
                this.isSwing = false;
                break;
            }
            this.log.warning("Process Info is null or interface type is not set. Testing isSwing = " + this.isSwing);
        } else {
            this.isSwing = this.processInfo.getInterfaceType().equals(ProcessInfo.INTERFACE_TYPE_SWING);
        }
        if (this.processInfo == null) {
            this.trxName = null;
            return true;
        }
        this.trxName = this.processInfo.getTransactionName();
        int ad_table_id = this.processInfo.getTable_ID();
        int record_id = this.processInfo.getRecord_ID();
        if (ad_table_id != 0) {
            String allowedTables = "C_Order,C_Invoice,C_Project";
            MTable table = MTable.get(this.ctx, ad_table_id);
            if (table.get_ID() <= 0) {
                this.log.severe("Unable to find table: " + ad_table_id);
                return false;
            }
            if (!allowedTables.contains(table.getTableName())) {
                this.log.severe("Table not supported for BOM Drop: " + ad_table_id);
                return false;
            }
            this.po = table.getPO(record_id, this.processInfo.getTransactionName());
            if (this.po == null) {
                this.log.severe("Unable to load PO for table and record: " + ad_table_id + ", " + record_id);
                return false;
            }
            if (this.po instanceof DocAction && !"DR".equals(((DocAction)((Object)this.po)).getDocStatus()) && !"IP".equals(((DocAction)((Object)this.po)).getDocStatus())) {
                this.log.severe("Document not draft or in progress: " + this.po.toString());
                return false;
            }
        }
        return true;
    }

    private void addListener(CEditor editor) {
        if (this.isSwing) {
            editor.addVetoableChangeListener(this);
        } else {
            editor.addValueChangeListener(this);
        }
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        try {
            this.eventResponse(evt, evt.getSource(), evt.getPropertyName(), evt.getNewValue(), evt.getOldValue());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        this.eventResponse(evt, evt.getSource(), evt.getPropertyName(), evt.getNewValue(), evt.getOldValue());
    }

    private void eventResponse(Object evt, Object source, String propertyName, Object newValue, Object oldValue) throws PropertyVetoException {
        if (!(source instanceof CEditor)) {
            return;
        }
        if ((newValue == null || newValue.toString().isEmpty()) && (oldValue == null || oldValue.toString().isEmpty()) || newValue != null && newValue.equals(oldValue)) {
            return;
        }
        CEditor editor = (CEditor)source;
        if (editor.equals(this.productEditor)) {
            if (newValue != null && newValue instanceof Integer) {
                this.m_product_id = (Integer)newValue;
                this.product = MProduct.get(this.ctx, this.m_product_id);
                if (this.productQtyEditor.getValue() == null || Env.ZERO.compareTo((BigDecimal)this.productQtyEditor.getValue()) == 0) {
                    this.productQtyEditor.setValue(Env.ONE);
                }
            } else {
                this.m_product_id = 0;
                this.product = null;
                this.productQtyEditor.setValue(null);
                this.productEditor.setBackground(true);
            }
            this.productEditor.setValue(newValue);
            this.productEditor.setBackground(this.product == null || this.product.getM_Product_ID() == 0);
            this.productQtyEditor.setBackground(this.product == null || this.product.getM_Product_ID() == 0);
            this.fillBOMList();
        }
        if (editor.equals(this.productQtyEditor)) {
            BigDecimal old;
            try {
                old = new BigDecimal((String)oldValue);
            }
            catch (NumberFormatException e) {
                old = null;
            }
            this.productQtyEditor.setValue(newValue);
            if (newValue == null || newValue.toString().isEmpty() || newValue instanceof Integer && ((Integer)newValue).compareTo(0) == 0 || newValue instanceof BigDecimal && ((BigDecimal)newValue).compareTo(Env.ZERO) == 0) {
                this.productQtyEditor.setBackground(true);
                return;
            }
            this.productQtyEditor.setBackground(false);
            if (((BigDecimal)newValue).compareTo(old) != 0) {
                this.updateBOMListQty();
            }
        }
        if (editor.equals(this.explodeBomEditor)) {
            this.fillBOMList();
        }
        if (editor.equals(this.orderEditor)) {
            this.orderEditor.setValue(newValue);
            if (newValue != null && newValue instanceof Integer) {
                int c_order_id = (Integer)newValue;
                if (c_order_id > 0) {
                    this.po = new MOrder(this.ctx, c_order_id, this.trxName);
                    this.orderEditor.setMandatory(true);
                    this.invoiceEditor.setMandatory(false);
                    this.invoiceEditor.setValue(null);
                    this.projectEditor.setMandatory(false);
                    this.projectEditor.setValue(null);
                } else {
                    this.po = null;
                }
            }
        }
        if (editor.equals(this.invoiceEditor)) {
            this.invoiceEditor.setValue(newValue);
            if (newValue != null && newValue instanceof Integer) {
                int c_invoice_id = (Integer)newValue;
                if (c_invoice_id > 0) {
                    this.po = new MInvoice(this.ctx, c_invoice_id, this.trxName);
                    this.invoiceEditor.setMandatory(true);
                    this.orderEditor.setMandatory(false);
                    this.orderEditor.setValue(null);
                    this.projectEditor.setMandatory(false);
                    this.projectEditor.setValue(null);
                } else {
                    this.po = null;
                }
            }
        }
        if (editor.equals(this.projectEditor)) {
            this.projectEditor.setValue(newValue);
            if (newValue != null && newValue instanceof Integer) {
                int c_project_id = (Integer)newValue;
                if (c_project_id > 0) {
                    this.po = new MProject(this.ctx, c_project_id, this.trxName);
                    this.projectEditor.setMandatory(true);
                    this.orderEditor.setMandatory(false);
                    this.orderEditor.setValue(null);
                    this.invoiceEditor.setMandatory(false);
                    this.invoiceEditor.setValue(null);
                } else {
                    this.po = null;
                }
            }
        }
        if (this.po == null) {
            this.orderEditor.setMandatory(true);
            this.invoiceEditor.setMandatory(true);
            this.projectEditor.setMandatory(true);
            this.orderEditor.setBackground(true);
            this.invoiceEditor.setBackground(true);
            this.projectEditor.setBackground(true);
        } else {
            this.orderEditor.setBackground(false);
            this.invoiceEditor.setBackground(false);
            this.projectEditor.setBackground(false);
        }
        int index = this.getEditorIndex(EDITORTYPE_CHECK, editor);
        if (index >= 0) {
            if ("CO".equals(this.selectionList.get((int)index).bomLine.getComponentType())) {
                editor.setValue(true);
                if (this.isSwing) {
                    PropertyChangeEvent pce = (PropertyChangeEvent)evt;
                    throw new PropertyVetoException(pce.getPropertyName(), pce);
                }
            }
            this.updateSelection();
            this.updateCaption(index, editor);
        } else {
            index = this.getEditorIndex(EDITORTYPE_QTY, editor);
            if (index >= 0 && newValue instanceof BigDecimal) {
                this.selectionList.get((int)index).qty = (BigDecimal)newValue;
                editor.setBackground(newValue == null);
            } else {
                index = this.getEditorIndex(EDITORTYPE_UOM, editor);
                if (index >= 0 && newValue != null && newValue instanceof Integer) {
                    int old_id = (Integer)oldValue;
                    int new_id = (Integer)newValue;
                    BigDecimal productQty = MUOMConversion.convertProductFrom(this.ctx, this.selectionList.get((int)index).m_product_id, old_id, this.selectionList.get((int)index).qty);
                    if (productQty == null) {
                        this.selectionList.get((int)index).uomEditor.setValue(oldValue);
                        this.selectionList.get((int)index).c_uom_id = old_id;
                        if (this.isSwing) {
                            PropertyChangeEvent pce = (PropertyChangeEvent)evt;
                            throw new PropertyVetoException(pce.getPropertyName(), pce);
                        }
                        return;
                    }
                    BigDecimal newQty = MUOMConversion.convertProductTo(this.ctx, this.selectionList.get((int)index).m_product_id, new_id, productQty);
                    if (newQty == null) {
                        this.selectionList.get((int)index).uomEditor.setValue(oldValue);
                        this.selectionList.get((int)index).c_uom_id = old_id;
                        if (this.isSwing) {
                            PropertyChangeEvent pce = (PropertyChangeEvent)evt;
                            throw new PropertyVetoException(pce.getPropertyName(), pce);
                        }
                        return;
                    }
                    newQty = newQty.setScale(MUOM.getPrecision(this.ctx, this.selectionList.get((int)index).c_uom_id), 4);
                    this.selectionList.get((int)index).c_uom_id = new_id;
                    this.selectionList.get((int)index).uomEditor.setValue(new_id);
                    this.selectionList.get((int)index).qtyEditor.setValue(newQty);
                    this.selectionList.get((int)index).qty = newQty;
                }
            }
        }
        this.enableConfirmOK();
    }

    private void updateBOMListQty() {
        if (this.productQtyEditor == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        BigDecimal qty = (BigDecimal)this.productQtyEditor.getValue();
        if (qty == null) {
            qty = Env.ZERO;
        }
        for (Selection list : this.selectionList) {
            list.qty = list.baseQty.multiply(qty);
            list.qtyEditor.setValue(list.qty);
        }
    }

    private int getEditorIndex(String editorType, CEditor editor) {
        if (!"CHECKQTYUOM".contains(editorType)) {
            throw new IllegalArgumentException("Unknonwn editorType: " + editorType);
        }
        if (editor == null) {
            return -1;
        }
        for (int i = 0; i < this.selectionList.size(); ++i) {
            if (!(EDITORTYPE_CHECK.equals(editorType) && editor.equals(this.selectionList.get((int)i).checkEditor) || EDITORTYPE_QTY.equals(editorType) && editor.equals(this.selectionList.get((int)i).qtyEditor)) && (!EDITORTYPE_UOM.equals(editorType) || !editor.equals(this.selectionList.get((int)i).uomEditor))) continue;
            return i;
        }
        return -1;
    }

    private void enableConfirmOK() {
        if (this.m_product_id > 0 && this.po != null) {
            this.form.enableConfirmOK(true);
        } else {
            this.form.enableConfirmOK(false);
        }
    }

    private void fillBOMList() {
        this.form.clearBOMList();
        this.selectionList.clear();
        this.knownFeatures.clear();
        this.canExplodeBOM = false;
        if (this.product != null) {
            this.form.setBOMListHeaders(" ", Msg.parseTranslation(this.ctx, MSG_BOMListHeaderProduct), Msg.parseTranslation(this.ctx, MSG_BOMListHeaderQty), Msg.parseTranslation(this.ctx, MSG_BOMListHeaderUOM));
            this.addBOMLines(this.product, (BigDecimal)this.productQtyEditor.getValue(), Env.ONE);
            this.updateSelection();
            this.updateCaption(-1, null);
            if (this.selectionList.size() > 0) {
                this.form.enableBOMList();
            }
            if (!this.canExplodeBOM) {
                this.explodeBomEditor.setValue(false);
                this.explodeBomEditor.setReadWrite(false);
            } else {
                this.explodeBomEditor.setReadWrite(true);
            }
        }
        this.form.sizeIt();
        this.enableConfirmOK();
    }

    public void confirmOK() {
        Trx localTrx;
        String trxName;
        block6: {
            if (this.m_product_id <= 0 || this.po == null) {
                this.log.severe("BOMDrop Confirmed (OK) but nothing selected or PO not identified.");
                this.dispose();
            }
            trxName = Trx.createTrxName("BOMDrop");
            localTrx = Trx.get(trxName, true);
            try {
                this.po.set_TrxName(trxName);
                if (this.po instanceof MOrder) {
                    this.saveOrder();
                    break block6;
                }
                if (this.po instanceof MInvoice) {
                    this.saveInvoice();
                    break block6;
                }
                if (this.po instanceof MProject) {
                    this.saveProject();
                    break block6;
                }
                throw new AdempiereException("Unknown PO: " + this.po.toString());
            }
            catch (AdempiereException e) {
                this.form.showDialog("Error", e.getLocalizedMessage());
                localTrx.rollback();
            }
        }
        localTrx.close();
        trxName = null;
        this.dispose();
    }

    private void dispose() {
        this.po = null;
        this.product = null;
        this.productEditor = null;
        this.invoiceEditor = null;
        this.orderEditor = null;
        this.projectEditor = null;
        this.form.dispose();
    }

    public void confirmCancel() {
        this.dispose();
    }

    private void addBOMLines(MProduct product, BigDecimal qty, BigDecimal baseQty) {
        if (product == null) {
            return;
        }
        MPPProductBOM bom = MPPProductBOM.getDefault(product, null);
        MPPProductBOMLine[] bomLines = bom.getLines(true);
        for (int i = 0; i < bomLines.length; ++i) {
            this.addBOMLine(product.getM_Product_ID(), bomLines[i], qty, baseQty);
        }
        this.log.fine("#" + bomLines.length);
    }

    private void addBOMLine(int parentProductID, MPPProductBOMLine line, BigDecimal qty, BigDecimal baseQty) {
        boolean explodeBOM;
        this.log.info(line.toString());
        String bomType = line.getComponentType();
        String itemType = null;
        BigDecimal lineQty = line.getQty();
        MProduct product = line.getProduct();
        if (product == null) {
            return;
        }
        if (product.isBOM() && product.isVerified()) {
            this.canExplodeBOM = true;
        }
        if ((explodeBOM = ((Boolean)this.explodeBomEditor.getValue()).booleanValue()) && product.isBOM() && product.isVerified()) {
            this.addBOMLines(product, lineQty.multiply(qty), lineQty.multiply(baseQty));
        } else {
            if ("CO".equals(bomType) || "OP".equals(bomType)) {
                itemType = EDITORTYPE_CHECK;
            } else if ("VA".equals(bomType)) {
                itemType = "RADIO";
            }
            if (!Util.isEmpty(itemType)) {
                BigDecimal displayedQty;
                Selection selection = new Selection();
                selection.bomLine = line;
                selection.type = itemType;
                selection.m_product_id = product.getM_Product_ID();
                selection.c_uom_id = line.getC_UOM_ID();
                selection.parentProductID = parentProductID;
                selection.feature = line.getFeature();
                selection.name = product.getName();
                selection.baseQty = line.getQty().multiply(baseQty);
                selection.qty = displayedQty = line.getQty().multiply(qty).setScale(MUOM.getPrecision(this.ctx, line.getC_UOM_ID()), 4);
                this.selectionList.add(selection);
                this.addDisplay(selection);
            }
        }
    }

    private void addDisplay(Selection selection) {
        Object featureObject = null;
        if (!Util.isEmpty(selection.bomLine.getFeature(), true)) {
            selection.feature = Util.cleanWhitespace(selection.bomLine.getFeature());
            selection.featureKey = selection.feature + "_" + String.valueOf(selection.parentProductID) + "_" + selection.type;
            featureObject = this.knownFeatures.get(selection.featureKey);
            if (featureObject == null) {
                featureObject = this.form.createFeature(selection.featureKey, selection.feature);
                this.knownFeatures.put(selection.featureKey, featureObject);
            }
        }
        MLookup uomLookup = null;
        MValRule valRule = MValRule.get(this.ctx, 210);
        String validation = valRule.getCode();
        validation = validation.replaceAll(MSG_BOMListHeaderProduct, "" + selection.m_product_id);
        int ad_column_id = MColumn.getColumn_ID("C_UOM", "C_UOM_ID");
        try {
            uomLookup = MLookupFactory.get(this.ctx, this.windowNo, ad_column_id, 19, Env.getLanguage(this.ctx), "C_UOM_ID", 0, false, validation);
        }
        catch (Exception e) {
            this.log.severe("Unable to load UOM lookup: " + e.getLocalizedMessage());
        }
        selection.checkEditor = this.form.addCheck(featureObject, selection.type, selection.name);
        selection.qtyEditor = this.form.addQty(featureObject, selection.qty);
        selection.uomEditor = this.form.addUOM(featureObject, uomLookup, selection.c_uom_id);
        this.addListener(selection.checkEditor);
        this.addListener(selection.qtyEditor);
        this.addListener(selection.uomEditor);
    }

    private boolean saveOrder() {
        this.log.config("C_Order_ID=" + this.po.get_ID());
        MOrder order = (MOrder)this.po;
        int lineCount = 0;
        for (int i = 0; i < this.selectionList.size(); ++i) {
            if (!this.selectionList.get((int)i).isSelected) continue;
            BigDecimal qty = this.selectionList.get((int)i).qty;
            int M_Product_ID = this.selectionList.get((int)i).m_product_id;
            int C_UOM_ID = this.selectionList.get((int)i).c_uom_id;
            MOrderLine ol = new MOrderLine(order);
            ol.setM_Product_ID(M_Product_ID, true);
            if (ol.getC_UOM_ID() != C_UOM_ID) {
                qty = MUOMConversion.convertProductFrom(this.ctx, M_Product_ID, C_UOM_ID, qty);
            }
            ol.setQty(qty);
            ol.setPrice();
            ol.setTax();
            ol.saveEx();
            ++lineCount;
        }
        String result = "@C_Order_ID@ " + order.getDocumentNo() + ": " + lineCount;
        result = Msg.parseTranslation(this.ctx, result);
        this.form.showDialog("Inserted", result);
        this.log.config("#" + lineCount);
        return true;
    }

    private boolean saveInvoice() {
        this.log.config("C_Invoice_ID=" + this.po.get_ID());
        MInvoice invoice = (MInvoice)this.po;
        int lineCount = 0;
        for (int i = 0; i < this.selectionList.size(); ++i) {
            if (!this.selectionList.get((int)i).isSelected) continue;
            BigDecimal qty = this.selectionList.get((int)i).qty;
            int M_Product_ID = this.selectionList.get((int)i).m_product_id;
            int C_UOM_ID = this.selectionList.get((int)i).c_uom_id;
            MInvoiceLine il = new MInvoiceLine(invoice);
            il.setM_Product_ID(M_Product_ID, true);
            if (il.getC_UOM_ID() != C_UOM_ID) {
                qty = MUOMConversion.convertProductFrom(this.ctx, M_Product_ID, C_UOM_ID, qty);
            }
            il.setQty(qty);
            il.setPrice();
            il.setTax();
            if (il.save()) {
                ++lineCount;
                continue;
            }
            this.log.log(Level.SEVERE, "Line not saved");
        }
        String result = "@C_Invoice_ID@ " + invoice.getDocumentNo() + ": " + lineCount;
        result = Msg.parseTranslation(this.ctx, result);
        this.form.showDialog("Inserted", result);
        this.log.config("#" + lineCount);
        return true;
    }

    private boolean saveProject() {
        this.log.config("C_Project_ID=" + this.po.get_ID());
        MProject project = (MProject)this.po;
        int lineCount = 0;
        for (int i = 0; i < this.selectionList.size(); ++i) {
            if (!this.selectionList.get((int)i).isSelected) continue;
            BigDecimal qty = this.selectionList.get((int)i).qty;
            int M_Product_ID = this.selectionList.get((int)i).m_product_id;
            MProjectLine pl = new MProjectLine(project);
            pl.setM_Product_ID(M_Product_ID);
            pl.setPlannedQty(qty);
            if (pl.save()) {
                ++lineCount;
                continue;
            }
            this.log.log(Level.SEVERE, "Line not saved");
        }
        String result = "@C_Project_ID@ " + project.getValue() + ": " + lineCount;
        result = Msg.parseTranslation(this.ctx, result);
        this.form.showDialog("Inserted", result);
        this.log.config("#" + lineCount);
        return true;
    }

    private void updateSelection() {
        for (int i = 0; i < this.selectionList.size(); ++i) {
            this.selectionList.get((int)i).isSelected = this.isItemSelected(this.selectionList.get((int)i).checkEditor);
            this.selectionList.get((int)i).qtyEditor.setReadWrite(this.selectionList.get((int)i).isSelected);
            this.selectionList.get((int)i).uomEditor.setReadWrite(this.selectionList.get((int)i).isSelected);
        }
    }

    private void updateCaption(int index, CEditor editor) {
        if (this.knownFeatures.isEmpty()) {
            return;
        }
        String featureDetail = "";
        ArrayList<String> features = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        if (index >= 0) {
            String featureKey = this.selectionList.get((int)index).featureKey;
            if (Util.isEmpty(featureKey)) {
                return;
            }
            features.add(featureKey);
            names.add(this.selectionList.get((int)index).feature);
        } else {
            for (int i = 0; i < this.selectionList.size(); ++i) {
                String featureKey = this.selectionList.get((int)i).featureKey;
                if (Util.isEmpty(featureKey) || features.indexOf(featureKey) >= 0) continue;
                features.add(featureKey);
                names.add(this.selectionList.get((int)i).feature);
            }
        }
        if (features.isEmpty()) {
            return;
        }
        for (int fi = 0; fi < features.size(); ++fi) {
            int countSelected = 0;
            boolean radioType = false;
            String name = "";
            String featureName = "";
            Object feature = null;
            BigDecimal qty = Env.ZERO;
            String featureKey = (String)features.get(fi);
            featureName = (String)names.get(fi);
            feature = this.knownFeatures.get(featureKey);
            int scale = 0;
            for (int i = 0; i < this.selectionList.size(); ++i) {
                if (!featureKey.equals(this.selectionList.get((int)i).featureKey) || !this.isItemSelected(this.selectionList.get((int)i).checkEditor)) continue;
                ++countSelected;
                name = this.selectionList.get((int)i).name;
                radioType = "RADIO".equals(this.selectionList.get((int)i).type);
                qty = this.selectionList.get((int)i).qty;
                scale = MUOM.getPrecision(this.ctx, this.selectionList.get((int)i).c_uom_id);
            }
            featureDetail = countSelected == 0 ? Msg.translate(this.ctx, MSG_NothingSelected) : (!radioType ? (countSelected == 1 ? countSelected + " " + Msg.translate(this.ctx, MSG_ItemSelectedSingular) : countSelected + " " + Msg.translate(this.ctx, MSG_ItemSelectedPlural)) : name + " (" + qty.setScale(scale).toString() + ")");
            this.form.updateFeatureCaption(feature, featureName + " - " + featureDetail);
        }
    }

    private boolean isItemSelected(CEditor cEditor) {
        Object value = cEditor.getValue();
        boolean sel = false;
        if (value != null) {
            sel = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
        }
        return sel;
    }

    private class Selection {
        public boolean isSelected;
        public int m_product_id;
        public BigDecimal qty;
        public int c_uom_id;
        public MPPProductBOMLine bomLine;
        public String name;
        public CEditor checkEditor;
        public CEditor qtyEditor;
        public CEditor uomEditor;
        public String featureKey;
        public String type;
        public int parentProductID;
        public String feature;
        public BigDecimal baseQty;
    }
}

