/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.controller;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.util.ListElement;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;

public abstract class SortTabController {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int tableId;
    private int columnSortOrderId;
    private int columnSortYesNoId;
    private String tableName = null;
    private String columnSortName = null;
    private String columnYesNoName = null;
    private String keyColumnName = null;
    private String m_IdentifierSql = null;
    private boolean m_IdentifierTranslated = false;
    private int m_WindowNo;
    private String m_ParentColumnName = null;
    private boolean isReadWrite = true;

    public SortTabController(int windowNo, int tableId, int columnSortOrderId, int columnSortYesNoId) {
        this.m_WindowNo = windowNo;
        this.tableId = tableId;
        this.columnSortOrderId = columnSortOrderId;
        this.columnSortYesNoId = columnSortYesNoId;
        this.dynInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dynInit() {
        boolean trl;
        int identifiersCount = 0;
        StringBuffer identifierSql = new StringBuffer();
        String sql = "SELECT t.TableName, c.AD_Column_ID, c.ColumnName, e.Name,c.IsParent, c.IsKey, c.IsIdentifier, c.IsTranslated FROM AD_Table t, AD_Column c, AD_Element e WHERE t.AD_Table_ID=? AND t.AD_Table_ID=c.AD_Table_ID AND (c.AD_Column_ID=? OR AD_Column_ID=? OR c.IsParent='Y' OR c.IsKey='Y' OR c.IsIdentifier='Y') AND c.AD_Element_ID=e.AD_Element_ID";
        boolean bl = trl = !Env.isBaseLanguage(Env.getCtx(), "AD_Element");
        if (trl) {
            sql = "SELECT t.TableName, c.AD_Column_ID, c.ColumnName, et.Name,c.IsParent, c.IsKey, c.IsIdentifier, c.IsTranslated FROM AD_Table t, AD_Column c, AD_Element_Trl et WHERE t.AD_Table_ID=? AND t.AD_Table_ID=c.AD_Table_ID AND (c.AD_Column_ID=? OR AD_Column_ID=?\tOR c.IsParent='Y' OR c.IsKey='Y' OR c.IsIdentifier='Y') AND c.AD_Element_ID=et.AD_Element_ID AND et.AD_Language=?";
        }
        sql = sql + " ORDER BY c.SeqNo";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.tableId);
            pstmt.setInt(2, this.columnSortOrderId);
            pstmt.setInt(3, this.columnSortYesNoId);
            if (trl) {
                pstmt.setString(4, Env.getAD_Language(Env.getCtx()));
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.tableName = rs.getString(1);
                if (this.columnSortOrderId == rs.getInt(2)) {
                    this.log.fine("Sort=" + rs.getString(1) + "." + rs.getString(3));
                    this.columnSortName = rs.getString(3);
                    continue;
                }
                if (this.columnSortYesNoId == rs.getInt(2)) {
                    this.log.fine("YesNo=" + rs.getString(1) + "." + rs.getString(3));
                    this.columnYesNoName = rs.getString(3);
                    continue;
                }
                if (rs.getString(5).equals("Y")) {
                    this.log.fine("Parent=" + rs.getString(1) + "." + rs.getString(3));
                    this.m_ParentColumnName = rs.getString(3);
                    continue;
                }
                if (rs.getString(6).equals("Y")) {
                    this.log.fine("Key=" + rs.getString(1) + "." + rs.getString(3));
                    this.keyColumnName = rs.getString(3);
                    continue;
                }
                if (rs.getString(7).equals("Y")) {
                    boolean isTranslated;
                    this.log.fine("Identifier=" + rs.getString(1) + "." + rs.getString(3));
                    boolean bl2 = isTranslated = trl && "Y".equals(rs.getString(8));
                    if (identifierSql.length() > 0) {
                        identifierSql.append(",");
                    }
                    identifierSql.append(this.getIdentifier(rs.getString(1), rs.getString(3), rs.getInt(2), isTranslated));
                    ++identifiersCount;
                    if (!isTranslated) continue;
                    this.m_IdentifierTranslated = true;
                    continue;
                }
                this.log.fine("??NotUsed??=" + rs.getString(1) + "." + rs.getString(3));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_IdentifierSql = identifiersCount == 0 ? "NULL" : (identifiersCount == 1 ? identifierSql.toString() : identifierSql.insert(0, "COALESCE(").append(")").toString());
        this.log.fine(this.columnSortName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT t.").append(this.keyColumnName).append(",").append(this.m_IdentifierSql).append(",t.").append(this.columnSortName).append(", t.AD_Client_ID, t.AD_Org_ID");
        if (this.columnYesNoName != null) {
            sql.append(",t.").append(this.columnYesNoName);
        }
        sql.append(" FROM ").append(this.tableName).append(" t");
        if (this.m_IdentifierTranslated) {
            sql.append(", ").append(this.tableName).append("_Trl tt");
        }
        if (this.m_ParentColumnName != null) {
            sql.append(" WHERE t.").append(this.m_ParentColumnName).append("=?");
        } else {
            sql.append(" WHERE 1=?");
        }
        if (this.m_IdentifierTranslated) {
            sql.append(" AND t.").append(this.keyColumnName).append("=tt.").append(this.keyColumnName).append(" AND tt.AD_Language=?");
        }
        sql.append(" ORDER BY ");
        if (this.columnYesNoName != null) {
            sql.append("6 DESC,");
        }
        sql.append("3,2");
        int ID = 0;
        if (this.m_ParentColumnName != null) {
            ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, this.m_ParentColumnName);
            this.log.fine(sql.toString() + " - ID=" + ID);
        } else {
            ID = 1;
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, ID);
            if (this.m_IdentifierTranslated) {
                pstmt.setString(2, Env.getAD_Language(Env.getCtx()));
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int key = rs.getInt(1);
                String name = rs.getString(2);
                int sequence = rs.getInt(3);
                boolean isYes = sequence != 0;
                int clientId = rs.getInt(4);
                int orgId = rs.getInt(5);
                if (this.columnYesNoName != null) {
                    isYes = rs.getString(6).equals("Y");
                }
                ListElement item = new ListElement(key, name, sequence, isYes, clientId, orgId, this.tableId);
                this.addItem(item);
                if (!isYes || item.isUpdateable()) continue;
                this.isReadWrite = false;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public String saveData(List<ListElement> noModel, List<ListElement> yesModel) {
        this.log.fine("");
        StringBuffer info = new StringBuffer();
        MTable table = MTable.get(Env.getCtx(), this.tableId);
        for (ListElement item : noModel) {
            if (!item.isUpdateable() || item.getSortNo() == 0 && (this.columnYesNoName == null || !item.isYes())) continue;
            PO po = table.getPO(item.getKey(), null);
            po.set_ValueOfColumn(this.columnSortName, (Object)0);
            po.set_ValueOfColumn(this.columnYesNoName, (Object)false);
            if (po.save()) {
                item.setSortNo(0);
                item.setIsYes(false);
                continue;
            }
            if (info.length() > 0) {
                info.append(", ");
            }
            info.append(item.getName());
            this.log.log(Level.SEVERE, "NoModel - Not updated: " + this.keyColumnName + "=" + item.getKey());
        }
        int index = 0;
        for (ListElement item : yesModel) {
            if (!item.isUpdateable() || item.getSortNo() == (index += 10) && (this.columnYesNoName == null || item.isYes())) continue;
            PO po = table.getPO(item.getKey(), null);
            po.set_ValueOfColumn(this.columnSortName, (Object)index);
            po.set_ValueOfColumn(this.columnYesNoName, (Object)true);
            if (po.save()) {
                item.setSortNo(index);
                item.setIsYes(true);
                continue;
            }
            if (info.length() > 0) {
                info.append(", ");
            }
            info.append(item.getName());
            this.log.log(Level.SEVERE, "YesModel - Not updated: " + this.keyColumnName + "=" + item.getKey());
        }
        if (info.length() > 0) {
            return info.toString();
        }
        return null;
    }

    private String getIdentifier(String tableName, String columnName, Integer AD_Column_ID, boolean isTranslated) {
        Language language = Language.getLanguage(Env.getAD_Language(Env.getCtx()));
        StringBuilder sql = new StringBuilder("");
        MColumn column = MColumn.get(Env.getCtx(), AD_Column_ID);
        if (19 == column.getAD_Reference_ID() || 30 == column.getAD_Reference_ID()) {
            sql.append("(").append(MLookupFactory.getLookup_TableDirEmbed(language, columnName, "t")).append(")");
        } else if (18 == column.getAD_Reference_ID()) {
            sql.append("(").append(MLookupFactory.getLookup_TableEmbed(language, column.getColumnName(), "t", column.getAD_Reference_Value_ID())).append(")");
        } else if (17 == column.getAD_Reference_ID()) {
            sql.append("(").append(MLookupFactory.getLookup_ListEmbed(language, column.getAD_Reference_Value_ID(), columnName)).append(")");
        } else {
            sql.append(isTranslated ? "tt." : "t.").append(columnName);
        }
        return sql.toString();
    }

    public boolean isReadWrite() {
        return this.isReadWrite;
    }

    public abstract void addItem(ListElement var1);
}

