/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.controller;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.GridField;
import org.compiere.model.MChangeLog;
import org.compiere.model.MColumn;
import org.compiere.model.MEntityType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.X_AD_Reference;
import org.compiere.model.X_AD_Val_Rule;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;

public class RecordInfoController {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Vector<Vector<String>> m_data = new Vector();
    private StringBuffer m_info = new StringBuffer();
    private GridField m_Field;
    private String m_Title;
    private boolean m_IsLoaded = false;
    private SimpleDateFormat m_dateTimeFormat = DisplayType.getDateFormat(16, Env.getLanguage(Env.getCtx()));
    private SimpleDateFormat m_dateFormat = DisplayType.getDateFormat(16, Env.getLanguage(Env.getCtx()));
    private DecimalFormat m_numberFormat = DisplayType.getNumberFormat(22, Env.getLanguage(Env.getCtx()));
    private DecimalFormat m_amtFormat = DisplayType.getNumberFormat(12, Env.getLanguage(Env.getCtx()));
    private DecimalFormat m_intFormat = DisplayType.getNumberFormat(11, Env.getLanguage(Env.getCtx()));

    public RecordInfoController(String title, DataStatusEvent dse, GridField mField) {
        this.dynInit(dse, title, mField);
    }

    private void dynInit(DataStatusEvent dse, String title, GridField mField) {
        this.m_Field = mField;
        int m_Record_ID = 0;
        int m_AD_Table_ID = 0;
        int m_AD_Column_ID = 0;
        String UUID = null;
        if (this.m_Field != null) {
            m_Record_ID = this.m_Field.getGridTab().getRecord_ID();
            UUID = this.m_Field.getGridTab().getUUID();
            m_AD_Table_ID = this.m_Field.getGridTab().getAD_Table_ID();
            m_AD_Column_ID = this.m_Field.getAD_Column_ID();
            MColumn column = MColumn.get(Env.getCtx(), m_AD_Column_ID);
            X_AD_Reference reference = new X_AD_Reference(Env.getCtx(), this.m_Field.getDisplayType(), null);
            DecimalFormat format = DisplayType.getNumberFormat(reference.getAD_Reference_ID());
            MTable table = MTable.get(Env.getCtx(), m_AD_Table_ID);
            StringBuilder infoTable = new StringBuilder();
            infoTable.append("SELECT * FROM ").append(table.getTableName()).append(" WHERE ");
            this.m_info.append((CharSequence)infoTable).append(this.m_Field.getColumnName()).append("=").append(this.m_Field.getValue()).append(";");
            if (UUID != null) {
                this.m_info.append("\n").append((CharSequence)infoTable).append("UUID='").append(UUID).append("';");
            }
            this.m_info.append("\n").append(Util.cleanAmp(Msg.translate(Env.getCtx(), "Name"))).append(": ").append(this.m_Field.getHeader()).append("\n").append(Msg.translate(Env.getCtx(), "Description")).append(": ").append(this.m_Field.getDescription()).append("\n").append(Msg.translate(Env.getCtx(), "AD_Reference_ID")).append(": ").append(reference.get_Translation("Name")).append("\n");
            if ((this.m_Field.getDisplayType() == 17 || this.m_Field.getDisplayType() == 18 || this.m_Field.getDisplayType() == 30) && this.m_Field.getAD_Reference_Value_ID() != 0) {
                X_AD_Reference referenceKey = new X_AD_Reference(Env.getCtx(), this.m_Field.getAD_Reference_Value_ID(), null);
                this.m_info.append(Msg.translate(Env.getCtx(), "AD_Reference_Value_ID")).append(": ").append(referenceKey.get_Translation("Name")).append(" (").append(this.m_Field.getAD_Reference_Value_ID()).append(")").append("\n");
            }
            if (column.getAD_Val_Rule_ID() != 0) {
                X_AD_Val_Rule validation = (X_AD_Val_Rule)column.getAD_Val_Rule();
                this.m_info.append(Msg.translate(Env.getCtx(), "AD_Val_Rule_ID")).append(": ").append(validation.get_Translation("Name")).append(" (").append(column.getAD_Val_Rule_ID()).append(")").append("\n");
            }
            this.m_info.append(Msg.translate(Env.getCtx(), "Length")).append(": ").append(format.format(column.getFieldLength())).append("\n");
            MEntityType entity = MEntityType.get(Env.getCtx(), column.getEntityType());
            this.m_info.append(Msg.translate(Env.getCtx(), "EntityType")).append(": ").append(entity.get_Translation("Name"));
            this.m_Title = title + " - " + this.m_Field.getHeader();
        } else {
            if (dse.CreatedBy == null) {
                return;
            }
            MUser user = MUser.get(Env.getCtx(), dse.CreatedBy);
            this.m_info.append(" ").append(Msg.translate(Env.getCtx(), "CreatedBy")).append(": ").append(user.getName()).append(" - ").append(this.m_dateTimeFormat.format(dse.Created)).append("\n");
            if (!dse.Created.equals(dse.Updated) || !dse.CreatedBy.equals(dse.UpdatedBy)) {
                if (!dse.CreatedBy.equals(dse.UpdatedBy)) {
                    user = MUser.get(Env.getCtx(), dse.UpdatedBy);
                }
                this.m_info.append(" ").append(Msg.translate(Env.getCtx(), "UpdatedBy")).append(": ").append(user.getName()).append(" - ").append(this.m_dateTimeFormat.format(dse.Updated)).append("\n");
            }
            if (dse.Info != null && dse.Info.length() > 0) {
                this.m_info.append("\n").append(dse.Info);
            }
            if (dse.AD_Table_ID != 0) {
                m_AD_Table_ID = dse.AD_Table_ID;
                MTable table1 = MTable.get(Env.getCtx(), dse.AD_Table_ID);
                this.m_Title = title + " - " + table1.getName();
            }
            if (dse.Record_ID instanceof Integer) {
                m_Record_ID = (Integer)dse.Record_ID;
            } else {
                this.log.info("dynInit - Invalid Record_ID=" + dse.Record_ID);
            }
        }
        if (m_Record_ID == 0) {
            return;
        }
        if (!"C".equals(MRole.getDefault().getPreferenceType())) {
            return;
        }
        String sql = "SELECT AD_Column_ID, Updated, UpdatedBy, OldValue, NewValue FROM AD_ChangeLog WHERE AD_Table_ID=? AND Record_ID=? " + (m_AD_Column_ID != 0 ? "AND AD_Column_ID=? " : "") + "ORDER BY Updated DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, m_AD_Table_ID);
            pstmt.setInt(2, m_Record_ID);
            if (m_AD_Column_ID != 0) {
                pstmt.setInt(3, m_AD_Column_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.addLine(rs.getInt(1), rs.getTimestamp(2), rs.getInt(3), rs.getString(4), rs.getString(5));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_IsLoaded = true;
    }

    protected boolean isOk() {
        return this.m_IsLoaded;
    }

    public Vector<String> getColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        if (this.m_Field == null) {
            columnNames.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "Name")));
        }
        columnNames.add(Msg.translate(Env.getCtx(), "NewValue"));
        columnNames.add(Msg.translate(Env.getCtx(), "OldValue"));
        columnNames.add(Msg.translate(Env.getCtx(), "UpdatedBy"));
        columnNames.add(Msg.translate(Env.getCtx(), "Updated"));
        if (this.m_Field == null) {
            columnNames.add(Msg.translate(Env.getCtx(), "AD_Column_ID"));
        }
        return columnNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addLine(int AD_Column_ID, Timestamp Updated, int UpdatedBy, String OldValue, String NewValue) {
        String showNewValue;
        String showOldValue;
        MColumn column;
        Vector<String> line;
        block28: {
            line = new Vector<String>();
            column = MColumn.get(Env.getCtx(), AD_Column_ID);
            if (this.m_Field == null) {
                line.add(Util.cleanAmp(Msg.translate(Env.getCtx(), column.getColumnName())));
            }
            if (OldValue != null && OldValue.equals(MChangeLog.NULL)) {
                OldValue = null;
            }
            showOldValue = OldValue;
            if (NewValue != null && NewValue.equals(MChangeLog.NULL)) {
                NewValue = null;
            }
            showNewValue = NewValue;
            try {
                if (DisplayType.isText(column.getAD_Reference_ID())) break block28;
                if (column.getAD_Reference_ID() == 20) {
                    boolean yes;
                    if (OldValue != null) {
                        yes = OldValue.equals("true") || OldValue.equals("Y");
                        showOldValue = Msg.getMsg(Env.getCtx(), yes ? "Y" : "N");
                    }
                    if (NewValue != null) {
                        yes = NewValue.equals("true") || NewValue.equals("Y");
                        showNewValue = Msg.getMsg(Env.getCtx(), yes ? "Y" : "N");
                    }
                    break block28;
                }
                if (column.getAD_Reference_ID() == 12) {
                    if (OldValue != null) {
                        showOldValue = this.m_amtFormat.format(new BigDecimal(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_amtFormat.format(new BigDecimal(NewValue));
                    }
                    break block28;
                }
                if (column.getAD_Reference_ID() == 11) {
                    if (OldValue != null) {
                        showOldValue = this.m_intFormat.format(new Integer(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_intFormat.format(new Integer(NewValue));
                    }
                    break block28;
                }
                if (DisplayType.isNumeric(column.getAD_Reference_ID())) {
                    if (OldValue != null) {
                        showOldValue = this.m_numberFormat.format(new BigDecimal(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_numberFormat.format(new BigDecimal(NewValue));
                    }
                    break block28;
                }
                if (column.getAD_Reference_ID() == 15) {
                    if (OldValue != null) {
                        showOldValue = this.m_dateFormat.format(Timestamp.valueOf(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_dateFormat.format(Timestamp.valueOf(NewValue));
                    }
                    break block28;
                }
                if (column.getAD_Reference_ID() == 16) {
                    if (OldValue != null) {
                        showOldValue = this.m_dateTimeFormat.format(Timestamp.valueOf(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_dateTimeFormat.format(Timestamp.valueOf(NewValue));
                    }
                    break block28;
                }
                if (DisplayType.isLookup(column.getAD_Reference_ID())) {
                    String key;
                    NamePair pp;
                    MLookup lookup = MLookupFactory.get(Env.getCtx(), 0, AD_Column_ID, column.getAD_Reference_ID(), Env.getLanguage(Env.getCtx()), column.getColumnName(), column.getAD_Reference_Value_ID(), column.isParent(), null);
                    if (OldValue != null && (pp = lookup.get(key = OldValue)) != null) {
                        showOldValue = pp.getName();
                    }
                    if (NewValue != null && (pp = lookup.get(key = NewValue)) != null) {
                        showNewValue = pp.getName();
                    }
                    break block28;
                }
                if (!DisplayType.isLOB(column.getAD_Reference_ID())) {
                    // empty if block
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, OldValue + "->" + NewValue, e);
            }
        }
        line.add(showNewValue);
        line.add(showOldValue);
        MUser user = MUser.get(Env.getCtx(), UpdatedBy);
        line.add(user.getName());
        line.add(this.m_dateFormat.format(Updated));
        if (this.m_Field == null) {
            line.add(column.getColumnName());
        }
        this.m_data.add(line);
    }

    public String getTitle() {
        return this.m_Title;
    }

    public Vector<Vector<String>> getData() {
        return this.m_data;
    }

    public String getInfo() {
        return this.m_info.toString();
    }
}

