/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.toolbar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.ad.process.ISvrProcessPrecondition;
import org.adempiere.ad.service.IDeveloperModeBL;
import org.adempiere.util.Check;
import org.adempiere.util.Services;
import org.compiere.model.GridTab;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Trx;

public class AProcessActionModel {
    private static final String ACTION_Name = "Process";
    private final CLogger logger = CLogger.getCLogger(this.getClass());
    private static final Map<Integer, List<Integer>> staticRegisteredProcesses = new HashMap<Integer, List<Integer>>();

    public String getActionName() {
        return ACTION_Name;
    }

    public List<MProcess> fetchProcesses(Properties ctx, GridTab gridTab) {
        List<MProcess> emptyList = Collections.unmodifiableList(new ArrayList());
        if (gridTab == null) {
            return emptyList;
        }
        MRole role = MRole.getDefault(ctx, false);
        Check.assumeNotNull(role, "No role found for {0}", ctx);
        List<MProcess> list = this.fetchProcessesForTab(ctx, gridTab);
        Iterator<MProcess> it = list.iterator();
        while (it.hasNext()) {
            MProcess process = it.next();
            Boolean accessRW = role.checkProcessAccess(process.getAD_Process_ID());
            if (accessRW == null) {
                this.logger.log(Level.FINE, "Removing process {0} because user has no access at all to it", process);
                it.remove();
                continue;
            }
            if (!accessRW.booleanValue()) {
                this.logger.log(Level.FINE, "Removing process {0} because user has only readonly access to it", process);
                it.remove();
                continue;
            }
            if (this.isPreconditionApplicable(process, gridTab)) continue;
            this.logger.log(Level.FINE, "Removing process {0} because preconditions were not met", process);
            it.remove();
        }
        return list;
    }

    public String getDisplayName(MProcess process) {
        String name = process.get_Translation("Name");
        IDeveloperModeBL developerModeBL = Services.get(IDeveloperModeBL.class);
        if (developerModeBL != null && developerModeBL.isEnabled()) {
            name = name + "/" + process.getValue();
        }
        return name;
    }

    public String getDescription(MProcess process) {
        String description = process.get_Translation("Description");
        IDeveloperModeBL developerModeBL = Services.get(IDeveloperModeBL.class);
        if (developerModeBL != null && developerModeBL.isEnabled()) {
            description = description == null ? "" : description + "\n - ";
            description = description + "Classname:" + process.getClassname() + ", ID=" + process.getAD_Process_ID();
        }
        return description;
    }

    private boolean isPreconditionApplicable(MProcess process, GridTab gridTab) {
        Class<?> processClass;
        if (Check.isEmpty(process.getClassname(), true)) {
            return true;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            processClass = classLoader.loadClass(process.getClassname());
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return false;
        }
        if (!ISvrProcessPrecondition.class.isAssignableFrom(processClass)) {
            return true;
        }
        try {
            ISvrProcessPrecondition svrProcessPrecondit = processClass.asSubclass(ISvrProcessPrecondition.class).newInstance();
            return svrProcessPrecondit.isPreconditionApplicable(gridTab);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return false;
        }
    }

    private List<MProcess> fetchProcessesForTab(Properties ctx, GridTab gridTab) {
        List<Integer> processIds = staticRegisteredProcesses.get(gridTab.getAD_Table_ID());
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(gridTab.getAD_Table_ID());
        String whereClause = "EXISTS( SELECT 1  FROM AD_Table_Process tp WHERE tp.AD_Table_ID=?\tAND tp.IsActive='Y' AND tp.AD_Process_ID=AD_Process.AD_Process_ID) OR EXISTS(\t\t\tSELECT 1 \t\t\tFROM AD_Field f \t\t\tINNER JOIN AD_Column c ON(c.AD_Column_ID = f.AD_Column_ID) \t\t\tWHERE f.AD_Tab_ID = " + gridTab.getAD_Tab_ID() + " \t\t\tAND c.AD_Process_ID = AD_Process.AD_Process_ID) OR " + "AD_Process_ID" + " IN " + DB.buildSqlList(processIds, params);
        List<MProcess> list = new Query(ctx, "AD_Process", whereClause, Trx.TRXNAME_None).setParameters(params).setOnlyActiveRecords(true).setOrderBy("Name").list(MProcess.class);
        return list;
    }

    public static void registerProcess(int adTableId, int adProcessId) {
        Check.assume(adTableId > 0, "adTableId > 0", new Object[0]);
        Check.assume(adProcessId > 0, "adProcessId > 0", new Object[0]);
        List<Integer> processIds = staticRegisteredProcesses.get(adTableId);
        if (processIds == null) {
            processIds = new ArrayList<Integer>();
            staticRegisteredProcesses.put(adTableId, processIds);
        }
        if (!processIds.contains(adProcessId)) {
            processIds.add(adProcessId);
        }
    }
}

